/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TAutoMainRel;
import com.yifu.cloud.plus.v1.yifu.archives.service.TAutoMainRelService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoMainRelAddVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoMainRelDetailVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoMainRelExportVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TAutoMainRelSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * 项目配置表主表
 *
 * @author fxj
 * @date 2025-03-13 15:15:26
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tautomainrel" )
@Tag(name = "项目配置表主表管理")
public class TAutoMainRelController {

    private final  TAutoMainRelService tAutoMainRelService;

	private final MenuUtil menuUtil;

    
    /**
     * 简单分页查询
     * @param page 分页对象
     * @param tAutoMainRel 项目配置表主表
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TAutoMainRel>> getTAutoMainRelPage(Page<TAutoMainRel> page, TAutoMainRelSearchVo tAutoMainRel) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tAutoMainRel);
        return  new R<>(tAutoMainRelService.getTAutoMainRelPage(page,tAutoMainRel));
    }
    /**
     * 不分页查询
     * @param tAutoMainRel 项目配置表主表
     * @return
     */
    @Operation(summary = "不分页查询", description = "不分页查询")
    @PostMapping("/noPage" )
    //@PreAuthorize("@pms.hasPermission('demo_tautomainrel_get')" )
    public R<List<TAutoMainRelExportVo>> getTAutoMainRelNoPage(@RequestBody TAutoMainRelSearchVo tAutoMainRel) {
        return R.ok(tAutoMainRelService.noPageDiy(tAutoMainRel));
    }

    /**
     * 通过id查询项目配置表主表及相关信息
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id查询", description = "通过id查询")
    @GetMapping("/{id}" )
    public R<TAutoMainRelDetailVo> getById(@PathVariable("id" ) String id) {
        return tAutoMainRelService.getByIdAsso(id);
    }

	/**
	 * 通过id查询项目配置表主表及相关信息
	 * @param deptId  deptNo
	 * @return R
	 */
	@Operation(summary = "通过项目信息查询项目配置", description = "通过项目信息查询项目配置")
	@GetMapping("/getProjectRule" )
	public R<TAutoMainRelDetailVo> getProjectRule(@RequestParam(required = false) String deptId,
												  @RequestParam(required = false) String deptNo) {
		return tAutoMainRelService.getProjectRule(deptId,deptNo);
	}

    /**
     * 新增项目配置表主表
     * @param entity 项目配置表主表
     * @return R
     */
    @Operation(summary = "新增项目配置表", description = "新增项目配置表")
    @SysLog("新增项目配置表" )
    @PostMapping("/save")
    public R<Boolean> save(@RequestBody TAutoMainRelAddVo entity) {
        return tAutoMainRelService.saveAsso(entity);
    }

    /**
     * 修改项目配置表主表
     * @param entity 项目配置表修改
     * @return R
     */
    @Operation(summary = "修改项目配置表主表", description = "修改项目配置表")
    @SysLog("修改项目配置表" )
    @PutMapping("/updateById")
    public R<Boolean> updateById(@RequestBody TAutoMainRelAddVo entity) {
        return tAutoMainRelService.updateAsso(entity);
    }

    /**
     * 通过id删除项目配置表主表
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除项目配置表主表", description = "通过id删除项目配置表主表：hasPermission('demo_tautomainrel_del')")
    @SysLog("通过id删除项目配置表主表" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('demo_tautomainrel_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tAutoMainRelService.removeById(id));
    }

    /**
	 * 项目配置表主表 批量导入
	 *
     * @author fxj
     * @date 2025-03-13 15:15:26
	 **/
    @SneakyThrows
    @Operation(description = "批量新增项目配置表主表 hasPermission('demo_tautomainrel-batch-import')")
    @SysLog("批量新增项目配置表主表")
    @PostMapping("/importListAdd")
    @PreAuthorize("@pms.hasPermission('demo_tautomainrel-batch-import')")
    public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file){
        return tAutoMainRelService.importDiy(file.getInputStream());
    }

    /**
     * 项目配置表主表 批量导出
     * @author fxj
     * @date 2025-03-13 15:15:26
     **/
    @Operation(description = "导出项目配置表主表 hasPermission('demo_tautomainrel-export')")
    @PostMapping("/export")
    public void export(HttpServletResponse response, @RequestBody TAutoMainRelSearchVo tAutoMainRel) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, tAutoMainRel);
		tAutoMainRelService.listExport(response,tAutoMainRel);
    }
}
