package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCompleteMonitor;
import com.yifu.cloud.plus.v1.yifu.archives.service.TCompleteMonitorService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.*;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.dapr.util.MenuUtil;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;


/**
 * 档案完整度监控
 *
 * @author huyc
 * @date 2024-06-17 16:08:58
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tcompletemonitor" )
@Tag(name = "档案完整度监控管理")
public class TCompleteMonitorController {

    private final TCompleteMonitorService tCompleteMonitorService;

	private final MenuUtil menuUtil;

	/**
	 * 档案完整度监控管理-全量 批量导出
	 *
	 * @author hgw
	 * @date 2024-6-24 16:01:47
	 **/
	@Operation(description =  "导出档案完整度监控管理-全量 权限：archves_tcompletemonitor_export_all")
	@PostMapping("/exportAll")
	@SysLog("导出档案完整度监控管理-全量")
	//@PreAuthorize("@pms.hasPermission('archves_tcompletemonitor_export_all')")
	public void exportAll(HttpServletResponse response, @RequestBody TCompleteMonitorSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		tCompleteMonitorService.exportAll(response, searchVo);
	}

    /**
     * 简单分页查询
     * @param page 分页对象
     * @param searchVo 档案完整度监控
     * @return
     */
    @Operation(description = "简单分页查询")
    @GetMapping("/page")
    public R<IPage<TCompleteMonitor>> getTCompleteMonitorPage(Page<TCompleteMonitor> page, TCompleteMonitorSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
        return new R<>(tCompleteMonitorService.getTCompleteMonitorPage(page,searchVo));
    }

	/**
	 * 查询人员明细
	 * @param page 分页对象
	 * @param completeMonitorInfoVo
	 * @return
	 */
	@Operation(description = "根据项目查询人员明细")
	@GetMapping("/empPage")
	public R<IPage<TCompleteMonitorInfoVo>> getMonitorEmpInfoListPage(Page<TCompleteMonitorInfoVo> page, TCompleteMonitorInfoVo completeMonitorInfoVo) {
		return new R<>(tCompleteMonitorService.getMonitorEmpInfoListPage(page,completeMonitorInfoVo));
	}

    /**
     * 通过id查询档案完整度监控
     * @param id id
     * @return R
     */
    @Operation(summary = "查看详情", description = "查看详情")
    @GetMapping("/{id}" )
    public R<TCompleteMonitor> getById(@PathVariable("id") String id) {
        return R.ok(tCompleteMonitorService.getById(id));
    }

    /**
     * 修改档案完整度监控
     * @param tCompleteMonitor 档案完整度监控
     * @return R
     */
    @Operation(summary = "修改档案完整度监控", description = "修改档案完整度监控：hasPermission('archves_tcompletemonitor_edit')")
    @SysLog("修改档案完整度监控" )
    @PutMapping
    @PreAuthorize("@pms.hasPermission('archves_tcompletemonitor_edit')" )
    public R<Boolean> updateById(@RequestBody TCompleteMonitor tCompleteMonitor) {
        return R.ok(tCompleteMonitorService.updateById(tCompleteMonitor));
    }

    /**
     * 通过id删除档案完整度监控
     * @param id id
     * @return R
     */
    @Operation(summary = "通过id删除档案完整度监控", description = "通过id删除档案完整度监控：hasPermission('archves_tcompletemonitor_del')")
    @SysLog("通过id删除档案完整度监控" )
    @DeleteMapping("/{id}" )
    @PreAuthorize("@pms.hasPermission('archves_tcompletemonitor_del')" )
    public R<Boolean> removeById(@PathVariable String id) {
        return R.ok(tCompleteMonitorService.removeById(id));
    }

	/**
	 * 通过id查询-主表
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/infoId")
	public R<EmpMainDetailVo> getInfoById(String id, String deptId) {
		return tCompleteMonitorService.getInfoById(id, deptId);
	}

    /**
     * 档案完整度监控 批量导出
     * @author huyc
     * @date 2024-06-17 16:08:58
     **/
    @Operation(description = "导出档案完整度监控 hasPermission('archves_tcompletemonitor-export')")
    @PostMapping("/export")
    @PreAuthorize("@pms.hasPermission('archves_tcompletemonitor-export')")
    public void export(HttpServletResponse response, @RequestBody TCompleteMonitorSearchVo searchVo) {
            tCompleteMonitorService.listExport(response,searchVo);
    }

	/**
	 * 档案完整度监控 批量生成
	 * @author huyc
	 * @date 2024-06-17 16:08:58
	 **/
	@Operation(description = "生成档案完整度监控")
	@Inner
	@PostMapping("/inner/createComlpeteMonitor")
	public void createComlpeteMonitor() {
		tCompleteMonitorService.createComlpeteMonitor();
	}

	/**
	 * 档案完整度监控 批量生成
	 * @author huyc
	 * @date 2024-06-17 16:08:58
	 **/
	@Operation(description = "根据项目编码刷新项目完整度状态")
	@PostMapping("/updateProjectStatusByDeptNo")
	public R updateProjectStatusByDeptNo(@RequestParam String deptNo) throws IllegalAccessException {
		tCompleteMonitorService.updateProjectStatusByDeptNo(deptNo);
		return R.ok();
	}

	/**
	 * 简单分页查询
	 * @param page 分页对象
	 * @param searchVo 档案待完善
	 * @return
	 */
	@Operation(description = "档案待完善列表分页查询")
	@GetMapping("/archivesPage")
	public R<IPage<EmployeeRegistrationProjectListVo>> getAllLackArchivesPage(Page<EmployeeRegistrationProjectListVo> page, EmployeeRegistrationPreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		return new R<>(tCompleteMonitorService.getAllLackArchivesPage(page,searchVo));
	}

	/**
	 * 档案待完善 批量导出
	 * @author huyc
	 * @date 2025-03-17 16:24:38
	 **/
	@Operation(description = "导出档案待完善")
	@PostMapping("/archivesExport")
	public void archivesExport(HttpServletResponse response, @RequestBody EmployeeRegistrationPreSearchVo searchVo) {
		YifuUser user = SecurityUtils.getUser();
		menuUtil.setAuthSql(user, searchVo);
		tCompleteMonitorService.archivesExport(response,searchVo);
	}
}
