/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TCustomerInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TCustomerInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;


/**
 * 客户信息
 *
 * @author hgw
 * @date 2022-06-20 09:59:17
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tcustomerinfo")
@Tag(name = "客户信息管理")
public class TCustomerInfoController {

	private final TCustomerInfoService tCustomerInfoService;

	/**
	 * 分页查询
	 *
	 * @param page          分页对象
	 * @param tCustomerInfo 客户信息
	 * @return
	 */
	@Operation(summary = "分页查询", description = "分页查询")
	@GetMapping("/page")
	public R<IPage<TCustomerInfo>> getTCustomerInfoPage(Page<TCustomerInfo> page, TCustomerInfo tCustomerInfo) {
		return R.ok(tCustomerInfoService.page(page, Wrappers.query(tCustomerInfo)));
	}


	/**
	 * 通过id查询客户信息
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询")
	@GetMapping("/{id}")
	public R<TCustomerInfo> getById(@PathVariable("id") String id) {
		return R.ok(tCustomerInfoService.getById(id));
	}

	/**
	 * 新增客户信息
	 *
	 * @param tCustomerInfo 客户信息
	 * @return R
	 */
	@Operation(summary = "新增客户信息", description = "新增客户信息")
	@SysLog("新增客户信息")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('tcustomerinfo_add')")
	public R<Boolean> save(@RequestBody TCustomerInfo tCustomerInfo) {
		return R.ok(tCustomerInfoService.save(tCustomerInfo));
	}

	/**
	 * 修改客户信息
	 *
	 * @param tCustomerInfo 客户信息
	 * @return R
	 */
	@Operation(summary = "修改客户信息", description = "修改客户信息")
	@SysLog("修改客户信息")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('tcustomerinfo_edit')")
	public R<Boolean> updateById(@RequestBody TCustomerInfo tCustomerInfo) {
		return R.ok(tCustomerInfoService.updateById(tCustomerInfo));
	}

	/**
	 * 通过id删除客户信息
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除客户信息", description = "通过id删除客户信息")
	@SysLog("通过id删除客户信息")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('tcustomerinfo_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tCustomerInfoService.removeById(id));
	}

}
