/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpContactInfo;
import com.yifu.cloud.plus.v1.yifu.archives.service.TEmpContactInfoService;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmpContactInfoSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.List;


/**
 * @author fxj
 * @date 2024-06-17 14:29:11
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tempcontactinfo")
@Tag(name = "紧急联系人")
public class TEmpContactInfoController {

	private final TEmpContactInfoService tEmpContactInfoService;


	/**
	 * 简单分页查询
	 *
	 * @param page            分页对象
	 * @param tEmpContactInfo
	 * @return
	 */
	@Operation(description = "简单分页查询")
	@GetMapping("/page")
	public R<IPage<TEmpContactInfo>> getTEmpContactInfoPage(Page<TEmpContactInfo> page, TEmpContactInfoSearchVo tEmpContactInfo) {
		return new R<>(tEmpContactInfoService.getTEmpContactInfoPage(page, tEmpContactInfo));
	}

	/**
	 * 不分页查询
	 *
	 * @param tEmpContactInfo
	 * @return
	 */
	@Operation(summary = "不分页查询", description = "不分页查询")
	@PostMapping("/noPage")
	//@PreAuthorize("@pms.hasPermission('archives_tempcontactinfo_get')" )
	public R<List<TEmpContactInfo>> getTEmpContactInfoNoPage(@RequestBody TEmpContactInfoSearchVo tEmpContactInfo) {
		return R.ok(tEmpContactInfoService.noPageDiy(tEmpContactInfo));
	}

	/**
	 * 通过id查询
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id查询", description = "通过id查询：hasPermission('archives_tempcontactinfo_get')")
	@GetMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tempcontactinfo_get')")
	public R<TEmpContactInfo> getById(@PathVariable("id") String id) {
		return R.ok(tEmpContactInfoService.getById(id));
	}

	/**
	 * 新增
	 *
	 * @param tEmpContactInfo
	 * @return R
	 */
	@Operation(summary = "新增", description = "新增：hasPermission('archives_tempcontactinfo_add')")
	@SysLog("新增")
	@PostMapping
	@PreAuthorize("@pms.hasPermission('archives_tempcontactinfo_add')")
	public R<Boolean> save(@RequestBody TEmpContactInfo tEmpContactInfo) {
		return R.ok(tEmpContactInfoService.save(tEmpContactInfo));
	}

	/**
	 * 修改
	 *
	 * @param tEmpContactInfo
	 * @return R
	 */
	@Operation(summary = "修改", description = "修改：hasPermission('archives_tempcontactinfo_edit')")
	@SysLog("修改")
	@PutMapping
	@PreAuthorize("@pms.hasPermission('archives_tempcontactinfo_edit')")
	public R<Boolean> updateById(@RequestBody TEmpContactInfo tEmpContactInfo) {
		return R.ok(tEmpContactInfoService.updateById(tEmpContactInfo));
	}

	/**
	 * 通过id删除
	 *
	 * @param id id
	 * @return R
	 */
	@Operation(summary = "通过id删除", description = "通过id删除：hasPermission('archives_tempcontactinfo_del')")
	@SysLog("通过id删除")
	@DeleteMapping("/{id}")
	@PreAuthorize("@pms.hasPermission('archives_tempcontactinfo_del')")
	public R<Boolean> removeById(@PathVariable String id) {
		return R.ok(tEmpContactInfoService.removeById(id));
	}

	/**
	 * 批量导入
	 *
	 * @author fxj
	 * @date 2024-06-17 14:29:11
	 **/
	@SneakyThrows
	@Operation(description = "批量新增 hasPermission('archives_tempcontactinfo-batch-import')")
	@SysLog("批量新增")
	@PostMapping("/importListAdd")
	@PreAuthorize("@pms.hasPermission('archives_tempcontactinfo-batch-import')")
	public R<List<ErrorMessage>> importListAdd(@RequestBody MultipartFile file) {
		return tEmpContactInfoService.importDiy(file.getInputStream());
	}

	/**
	 * 批量导出
	 *
	 * @author fxj
	 * @date 2024-06-17 14:29:11
	 **/
	@Operation(description = "导出 hasPermission('archives_tempcontactinfo-export')")
	@PostMapping("/export")
	@PreAuthorize("@pms.hasPermission('archives_tempcontactinfo-export')")
	public void export(HttpServletResponse response, @RequestBody TEmpContactInfoSearchVo searchVo) {
		tEmpContactInfoService.listExport(response, searchVo);
	}
}
