/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.fadada.api.bean.rsp.sign.SignUrlRsp;
import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractAttachInfo;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddContractInfo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * 法大大合同与员工合同信息
 *
 * @author fxj
 * @date 2022-06-29 16:21:51
 */
public interface FddContractInfoService extends IService<FddContractInfo> {

	/**
	 * 发送法大大电子合同定稿任务
	 * @param fddContractInfo 法大大合同信息表
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @return R
	 */
	R<String> saveEmpContract(FddContractAttachInfo fddContractInfo, YifuUser user) throws ApiException;

	/**
	 * 作废重签
	 * @param fddContractInfo 法大大合同信息表
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @return R
	 */
	R<String> invalidAndsend(FddContractInfo fddContractInfo) throws ApiException;

	/**
	 * 获取在线定稿地址
	 * @param fddContractInfo
	 * @param roleName
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @return R
	 */
	R<String> getFillFileUrl(FddContractInfo fddContractInfo,String roleName) throws ApiException;

	/**
	 * 引用模板创建签署任务
	 * @param fddContractInfo
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @return R
	 */
	R<String> createTaskByDraftId(FddContractInfo fddContractInfo) throws ApiException;

	/**
	 * 获取签署链接
	 * @param fddContractInfo
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @return R
	 */
	R<Map<String, List<SignUrlRsp>>> getSignUrl(FddContractInfo fddContractInfo) throws ApiException;

	/**
	 * 获取签署链接
	 * @param fddContractInfo
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @return R
	 */
	R<String> getSignPreviewUrl(FddContractInfo fddContractInfo) throws ApiException;

	/**
	 * 获取签署链接
	 * @param fddContractInfo
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @return: void
	 */
	void getBySignFileId(FddContractInfo fddContractInfo, HttpServletResponse response) throws ApiException, IOException;

	/**
	 * 签署文件转移为合同附件
	 * @param fddContractInfo
	 * @param response
	 * @Author: huyc
	 * @Date: 2022/6/30
	 * @return: R
	 **/
	R<String> moveFileToEmpConcat(FddContractInfo fddContractInfo, HttpServletResponse response) throws ApiException, IOException;

	R<String> generalEmployeeParam(FddContractAttachInfo attachInfo, boolean signFlag);
}
