/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpOtherFile;

import java.util.List;

/**
 * 档案-其他附件主表
 *
 * @author hgw
 * @date 2024-07-17 14:56:33
 */
public interface TEmpOtherFileService extends IService<TEmpOtherFile> {

	/**
	 * @param empId
	 * @Description: 获取list，预入职使用
	 * @Author: hgw
	 * @Date: 2024/6/21 9:51
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpOtherFile>
	 **/
	List<TEmpOtherFile> getListByEmpId(String empId);

	/**
	 * @param empId 档案id
	 * @Description: 给前端使用，查询其他附件
	 * @Author: hgw
	 * @Date: 2024/7/17 16:39
	 * @return: java.util.List<com.yifu.cloud.plus.v1.yifu.archives.entity.TEmpOtherFile>
	 **/
	List<TEmpOtherFile> getTEmpOtherFileListAndFile(String empId);

	/**
	 * @param empId
	 * @Description: 删除档案附属表信息（预入职清空附属信息专用，其余的请慎用）
	 * @Author: hgw
	 * @Date: 2024/6/19 18:27
	 * @return: void
	 **/
	void deleteOtherFileByEmpId(String empId);
}
