package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeRetirement;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TEmployeeRetirementFlagDetail;
import com.yifu.cloud.plus.v1.yifu.archives.vo.ChangeHandleFlagAllVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.ChangeHandleFlagVo;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TEmployeeRetirementSearchVo;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
* @author 86187
* @description 针对表【t_employee_retirement】的数据库操作Service
* @createDate 2023-05-18 15:40:46
*/
public interface TEmployeeRetirementService extends IService<TEmployeeRetirement> {

    /**
     * 人员退休提醒分页列表
     *
     * @author wzb
     * @param page
     * @param searchVo
     * @return {@link IPage< TEmployeeRetirement>}
     */
	IPage<TEmployeeRetirement> getTEmployeeRetirementPage(Page page, TEmployeeRetirementSearchVo searchVo);

	/**
	 * 批量修改状态
	 *
	 * @author wzb
	 * @param changeHandleFlagAllVo
	 * @return {@link boolean}
	 */
	boolean changeHandleFlagAll(ChangeHandleFlagAllVo changeHandleFlagAllVo);

	/**
	 * 修改状态
	 *
	 * @author wzb
	 * @param changeHandleFlagVo
	 * @return {@link boolean}
	 */
	boolean changeHandleFlag(ChangeHandleFlagVo changeHandleFlagVo);

	/**
	 * 退休提醒人员导出
	 *
	 * @author wzb
	 * @param response
	 * @param searchVo
	 * @return void
	 */
	 void  listExport (HttpServletResponse response, TEmployeeRetirementSearchVo searchVo);

	 /**
	  * 退休提醒定时任务
	  *
	  * @author wzb
	  * @param
	  * @return void
	  */
	 void retireeRemind() ;

	 /**
	  * 获取处理日志
	  *
	  * @author wzb
	  * @param id
	  * @return {@link List< TEmployeeRetirementFlagDetail>}
	  */
	 List<TEmployeeRetirementFlagDetail> getHandleFlagDetail(String id);

}
