/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.archives.service;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.archives.entity.TRiskMonitor;
import com.yifu.cloud.plus.v1.yifu.archives.vo.TRiskMonitorSearchVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import javax.servlet.http.HttpServletResponse;

/**
 * 风险管控统计
 *
 * @author huych
 * @date 2024-09-25 10:01:06
 */
public interface TRiskMonitorService extends IService<TRiskMonitor> {
    /**
     * 风险管控统计简单分页查询
     * @param tRiskMonitor 风险管控统计
     * @return
     */
    IPage<TRiskMonitor> getTRiskMonitorPage(Page<TRiskMonitor> page, TRiskMonitorSearchVo tRiskMonitor);

	/**
	 * 风险管控统计导出
	 * @param searchVo 风险管控统计
	 * @return
	 */
    void listExport(HttpServletResponse response, TRiskMonitorSearchVo searchVo);

	/**
	 * 生成管控统计
	 * @return
	 */
	void createRiskMonitor();

	/**
	 * 查询风险占比
	 * @return
	 */
	R selectCurrentRiskMonitor(TRiskMonitorSearchVo tRiskMonitor);


}
