/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.yifu.archives.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.fadada.api.bean.req.BaseReq;
import com.fadada.api.bean.rsp.BaseRsp;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddReqLog;
import com.yifu.cloud.plus.v1.yifu.archives.mapper.FddReqLogMapper;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddReqLogService;
import org.springframework.stereotype.Service;

/**
 * 法大大日志记录表
 *
 * @author fxj
 * @date 2022-06-28 16:24:12
 */
@Service
public class FddReqLogServiceImpl extends ServiceImpl<FddReqLogMapper, FddReqLog> implements FddReqLogService {

	/**
	 * 法大大日志记录表简单分页查询
	 *
	 * @param fddReqLog 法大大日志记录表
	 * @return
	 */
	@Override
	public IPage<FddReqLog> getFddReqLogPage(Page<FddReqLog> page, FddReqLog fddReqLog) {
		return baseMapper.getFddReqLogPage(page, fddReqLog);
	}

	@Override
	public void saveLog(String className,String methodName,BaseReq req, BaseRsp rsp) {
		FddReqLog fddReqLog = new FddReqLog();
		fddReqLog.setReqData(JSON.toJSONString(req));
		fddReqLog.setResData(JSON.toJSONString(rsp));
		fddReqLog.setMethodName(methodName);
		fddReqLog.setClassName(className);
		this.save(fddReqLog);
	}
}
