/**
 * Copyright © 2017yifu. All rights reserved.
 *
 * @Title: NumberToCN.java
 * @Prject: wanxin_hr
 * @Package: com.yifu.util
 * @Description: TODO
 * @author: Administrator
 * @date: 2017年5月8日 下午6:45:01
 * @version: V1.0
 */
package com.yifu.cloud.plus.v1.yifu.archives.utils;

import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.alibaba.excel.write.metadata.style.WriteFont;
import com.alibaba.excel.write.style.HorizontalCellStyleStrategy;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;

import java.math.BigDecimal;

/**
 * @Author: wangan
 * @Date: 2019/8/9
 * @Description: 金额转换金额大写, 从老hr复制过
 * @return:
 **/
public class ExcelStyle {
	/**
	 * @param
	 * @Description: 设置倩倩审美下的excel样式
	 * @Author: hgw
	 * @Date: 2024/7/9 20:30
	 * @return: com.alibaba.excel.write.style.HorizontalCellStyleStrategy
	 **/
	public static HorizontalCellStyleStrategy getNormalStype () {
		// 表头——单元格样式对象
		WriteCellStyle headWriteCellStyle = new WriteCellStyle();
		headWriteCellStyle.setWrapped(false);
		// 背景设置为白色，也可设置为其他颜色
		headWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
		// 设置表头字体
		WriteFont headWriteFont = new WriteFont();
		// 设置字体大小为12
		headWriteFont.setFontHeightInPoints((short)12);
		// 设置加粗
		headWriteFont.setBold(true);
		// 把字体对象设置到单元格样式对象中
		headWriteCellStyle.setWriteFont(headWriteFont);
		//设置表头居中
		headWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);

		// 内容——单元格样式对象
		WriteCellStyle contentWriteCellStyle = new WriteCellStyle();
		contentWriteCellStyle.setWrapped(false);
		// 背景设置为白色，也可设置为其他颜色
		contentWriteCellStyle.setFillForegroundColor(IndexedColors.WHITE.getIndex());
		contentWriteCellStyle.setBorderTop(BorderStyle.THIN);
		contentWriteCellStyle.setBorderBottom(BorderStyle.THIN);
		contentWriteCellStyle.setBorderLeft(BorderStyle.THIN);
		contentWriteCellStyle.setBorderRight(BorderStyle.THIN);
		// 设置表头字体
		WriteFont contentWriteFont = new WriteFont();
		// 设置字体大小为12
		contentWriteFont.setFontHeightInPoints((short)11);
		// 把字体对象设置到单元格样式对象中
		contentWriteCellStyle.setWriteFont(contentWriteFont);
		//设置表头居中
		contentWriteCellStyle.setHorizontalAlignment(HorizontalAlignment.CENTER);
		HorizontalCellStyleStrategy horizontalCellStyleStrategy = new HorizontalCellStyleStrategy(headWriteCellStyle, contentWriteCellStyle);
		return horizontalCellStyleStrategy;
	}
}
