package com.yifu.cloud.plus.v1.yifu.archives.utils;

import com.alibaba.fastjson.JSON;
import com.fadada.api.*;
import com.fadada.api.bean.rsp.BaseRsp;
import com.fadada.api.bean.rsp.oauth2.AccessTokenRsp;
import com.fadada.api.client.Oauth2Client;
import com.fadada.api.exception.ApiException;
import com.yifu.cloud.plus.v1.yifu.archives.config.FddConfigProperties;
import com.yifu.cloud.plus.v1.yifu.archives.entity.FddReqLog;
import com.yifu.cloud.plus.v1.yifu.archives.service.FddReqLogService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.exception.CheckedException;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * @auther wangan
 * @date 2021/1/18
 * 法大大工具类
 */
@Slf4j
@Component
@EnableConfigurationProperties(FddConfigProperties.class)
public class FddUtil {

	public static final String SUCCESS = "100000";
	//法大大员工角色
	public static final String PERSON = "person";
	//法大大公司角色
	public static final String COMPANY = "company";

	@Autowired
	private FddReqLogService reqLogService;

	@Autowired
	private RedisTemplate<String, String> stringRedisTemplate;

	@Autowired
	private FddConfigProperties config;

	/**
	 * @param
	 * @Author: wangan
	 * @Date: 2021/1/18
	 * @Description: 法大大请求对象
	 * @return: com.fadada.api.FadadaApiClient
	 **/
	public FadadaApiClient getFadadaApiClient() {
		FadadaApiConfig fadadaApiConfig = new FadadaApiConfig();
		fadadaApiConfig.setReadTimeout(config.getReadTimeout());
		fadadaApiConfig.setConnectTimeout(config.getConnectTimeout());
		// DefaultFadadaApiServiceImpl实现了接口FadadaApiService接口提供了json字符串转换以及http请求方法
		// 如果要自定义实现json和http方法，只需要实现FadadaApiService接口方法
		FadadaApiService fadadaApiService = new DefaultFadadaApiServiceImpl();
		DefaultFadadaApiClient client = new DefaultFadadaApiClient(config.getAppId(), config.getAppKey(), config.getServerUrl(), fadadaApiConfig,
				fadadaApiService);
		return client;
	}

	/**
	 * @param
	 * @Author: wangan
	 * @Date: 2021/1/18
	 * @Description: 获取token
	 * @return: java.lang.String
	 **/
	public String getToken() throws ApiException {
		String accessTokenKey = "fdd_access_token";
		ValueOperations<String, String> stringValueOperations = stringRedisTemplate.opsForValue();
		String accessToken = stringValueOperations.get(accessTokenKey);
		if (StringUtils.isEmpty(accessToken)) {
			Oauth2Client oauth2Client = new Oauth2Client(getFadadaApiClient());
			BaseRsp<AccessTokenRsp> rsp = oauth2Client.getToken();
			AccessTokenRsp data = rsp.getData();
			if (data == null || StringUtils.isEmpty(data.getAccessToken())) {
				log.error("法大大返回:" + JSON.toJSON(data));
				throw new CheckedException("获取法大大token失败");
			}
			accessToken = data.getAccessToken();
			stringValueOperations.set(accessTokenKey, accessToken, CommonConstants.dingleDigitIntArray[2], TimeUnit.HOURS);
			//记录日志
			FddReqLog fddReqLog = new FddReqLog();
			fddReqLog.setReqData("getToken");
			fddReqLog.setResData(JSON.toJSONString(data));
			fddReqLog.setMethodName(Thread.currentThread().getStackTrace()[1].getMethodName());
			fddReqLog.setClassName(Thread.currentThread().getStackTrace()[1].getClassName());
			reqLogService.save(fddReqLog);
		}
		return accessToken;
	}
}
