package com.yifu.cloud.plus.v1.business.dto.vacation;


import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * @description: 假勤信息表 新增或更新记录dto
 * @author: wangweiguo
 * @date: 2021-08-20
*/

@Setter
@Getter
@ToString
public class AddOrUpdateTVacationInfoDTO implements Serializable  {

    /**
     * b端员工工号
     */
	@Schema(description = "电信工号")
	@NotBlank(message = "电信工号不能为空")
    @Length(max = 20, message = "电信工号不能超过20字符")
    private String businessTelecomNumber;

    /**
     * 人员姓名
     */
	@Schema(description = "人员姓名")
	@NotBlank(message = "人员姓名不能为空")
    @Length(max = 32, message = "人员姓名不能超过32字符")
    private String empName;

    /**
     * 身份证号码
     */
	@Schema(description = "身份证号码")
	@NotBlank(message = "身份证号码不能为空")
    @Length(max = 32, message = "身份证号码不能超过32字符")
    private String empIdcard;

    /**
     * 部门id
     */
	@Schema(description = "部门id")
	private Integer departId;

    /**
     * 部门名称
     */
	@Schema(description = "部门名称")
	private String departName;

    /**
     * b端岗位
     */
	@Schema(description = "岗位")
	@Length(max = 32, message = "岗位不能超过32字符")
    private String businessPost;

    /**
     * 假勤类型（字典值）
     */
	@Schema(description = "假勤类型（字典值）")
	@NotBlank(message = "假勤类型不能为空")
    private String vacationType;

    /**
     * 假勤开始时间
     */
	@Schema(description = "假勤开始时间")
	@NotNull(message = "假勤开始时间不能为空")
    private LocalDateTime vacationStartTime;

    /**
     * 假勤结束时间
     */
	@Schema(description = "假勤结束时间")
	@NotNull(message = "假勤结束时间不能为空")
    private LocalDateTime vacationEndTime;

    /**
     * 假勤时长
     */
	@Schema(description = "假勤时长")
	@NotNull(message = "假勤时长不能为空")
    private BigDecimal vacationDuration;

    /**
     * 假勤事由
     */
	@Schema(description = "假勤事由")
	@Length(max = 200, message = "假勤事由不能超过200字符")
    private String vacationReason;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}

