package com.yifu.cloud.plus.v1.business.entity.system;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;


/**
 * @author fxj
 * @date 2021-08-18 14:51:15
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("sys_bus_dict")
@Schema(description = "")
public class SysBusDict extends Model<SysBusDict> {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    @TableId(type = IdType.ASSIGN_ID)
    @Schema(description = "主键")
    private String id;
    /**
     * 字典名称
     */
    @Length(max = 20, message = "字典名称不能超过20个字符")
    @ExcelAttribute(name = "字典名称", maxLength = 20)
    @Schema(description = "字典名称")
    private String label;
    /**
     * 字典值
     */
    @Length(max = 20, message = "字典值不能超过20个字符")
    @ExcelAttribute(name = "字典值", maxLength = 20)
    @Schema(description = "字典值")
    private String value;
    /**
     * 字典编码
     */
    @Length(max = 20, message = "字典编码不能超过20个字符")
    @ExcelAttribute(name = "字典编码", maxLength = 20)
    @Schema(description = "字典编码")
    private String itemType;
    /**
     * 字典状态 0 启用  1  禁用
     */
    @NotBlank(message = "字典状态不能为空")
    @Length(max = 1, message = "字典状态不能超过1个字符")
    @ExcelAttribute(name = "字典状态", isNotEmpty = true, errorInfo = "字典状态不能为空", maxLength = 1)
    @Schema(description = "字典状态（0 启用  1  禁用）")
    private String status;
}
