package com.yifu.cloud.plus.v1.business.entity.vacation;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 假期监控表
 * @TableName t_vacation_monitor
 */
@TableName(value ="t_vacation_monitor")
@Data
public class TVacationMonitor extends Model<TVacationMonitor> {
	/**
	 *
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "")
	private String id;

    /**
     * 年份
     */
    private String vacationYear;

    /**
     * 电信工号
     */
    private String businessTelecomNumber;

    /**
     * 身份证号码
     */
    private String empIdcard;

    /**
     * 姓名
     */
    private String empName;

    /**
     * 部门id
     */
    private Integer departId;

    /**
     * b端岗位
     */
    private String businessPost;

    /**
     * 假期时长
     */
    private BigDecimal vacationDuration;

    /**
     * 未使用假期时长
     */
    private BigDecimal notUsedVacationDuration;

    /**
     * 入职时间
     */
    private LocalDateTime businessEnjoinDate;

    /**
     * 休假状态 0未休完 1已休完
     */
    private String vacationStatus;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}