package com.yifu.cloud.plus.v1.business.controller.system;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.system.TBusLable;
import com.yifu.cloud.plus.v1.business.service.system.TBusLableService;
import com.yifu.cloud.plus.v1.business.vo.system.BusLableVo;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.time.LocalDateTime;
import java.util.List;


/**
 * B端标签表
 *
 * @author hgw
 * @date 2021-08-11 17:00:52
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tbuslable")
@Tag(name = "B端标签表")
public class TBusLableController {

     private final TBusLableService tBusLableService;

     /**
      * 简单分页查询
      *
      * @param page      分页对象
      * @param tBusLable B端标签表
      * @return
      */
	 @Operation(summary = "简单分页查询", description = "简单分页查询")
	 @GetMapping("/page")
     public R<IPage<TBusLable>> getTBusLablePage(Page<TBusLable> page, TBusLable tBusLable) {
          return new R<>(tBusLableService.getTBusLablePage(page, tBusLable));
     }

     /**
      * 获取list
      *
      * @param tBusLable B端标签表
      * @return
      */
	 @Operation(description = "获取list，status：是否启用，0启用,1禁用")
	 @GetMapping("/getTBusLableList")
     public R<List<TBusLable>> getTBusLableList(TBusLable tBusLable) {
          return new R<>(tBusLableService.getTBusLableList(tBusLable));
     }

	 /**
	  * @param tBusLable
	  * @Description: B端人员调用的标签
	  * @Author: hgw
	  * @Date: 2023/1/4 11:38
	  * @return: com.yifu.cloud.plus.v1.business.vo.system.BusLableVo
	  **/
	 @PostMapping("/inner/getTBusLableList")
	 @Inner
     public BusLableVo innerGetTBusLableList(TBusLable tBusLable) {
		 BusLableVo busLableVo = new BusLableVo();
		 busLableVo.setBusLableList(tBusLableService.getTBusLableList(tBusLable));
	     return busLableVo;
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询", description = "id查询")
	 @GetMapping("/{id}")
     public R<TBusLable> getById(@PathVariable("id") Integer id) {
          return new R<>(tBusLableService.getById(id));
     }

     /**
      * 通过idStr查询单条记录
      *
      * @param idStr
      * @return R
      */
	 @Operation(summary = "idStr查询", description = "idStr查询")
	 @PostMapping("/getByIdStr")
     public R<List<TBusLable>> getByIdStr(@RequestParam String idStr) {
		 List<String> list = Common.getList(idStr);
          return new R<>(tBusLableService.list(Wrappers.<TBusLable>query().lambda().in(TBusLable::getId, list)));
     }

     /**
      * 新增记录
      *
      * @param tBusLable
      * @return R
      */
	 @Operation(summary = "新增(yifu-mvp-business:tbuslable_add)", description = "新增(yifu-mvp-business:tbuslable_add)")
	 @PostMapping
//     @PreAuthorize("@pms.hasPermission('yifu-mvp-business:tbuslable_add')")
     public R<Boolean> save(@RequestBody TBusLable tBusLable) {
          if (Common.isNotNull(tBusLable.getName())) {
               boolean flag = this.getLableByName(null, tBusLable.getName());
               if (flag) {
                    return R.failed("标签名称不可重复");
               }
          } else {
               return R.failed("标签名称不可为空");
          }
          YifuUser user = SecurityUtils.getUser();
          if (user != null && user.getId() != null) {
               tBusLable.setCreateTime(LocalDateTime.now());
               tBusLable.setCreateUserId(String.valueOf(user.getId()));
               tBusLable.setCreateUserName(user.getNickname());
               return new R<>(tBusLableService.save(tBusLable));
          } else {
               return R.failed("未获取到登录人信息");
          }
     }

     /**
      * 检查名称是否重复，false：不重复，可以使用的名称
      *
      * @param name 名称
      * @return
      */
     private boolean getLableByName(Integer id, String name) {
          List<TBusLable> list = tBusLableService.getLableByName(id, name);
          return (list != null && !list.isEmpty());
     }

     /**
      * 修改记录
      *
      * @param tBusLable
      * @return R
      */
	 @Operation(summary = "修改(yifu-mvp-business:tbuslable_edit)", description = "修改(yifu-mvp-business:tbuslable_edit)")
	 @SysLog("修改B端标签表")
     @PutMapping
//     @PreAuthorize("@pms.hasPermission('yifu-mvp-business:tbuslable_edit')")
     public R<Boolean> update(@RequestBody TBusLable tBusLable) {
          if (Common.isNotNull(tBusLable.getId()) && Common.isNotNull(tBusLable.getName())) {
               boolean flag = this.getLableByName(tBusLable.getId(), tBusLable.getName());
               if (flag) {
                    return R.failed("标签名称不可重复");
               }
          } else {
               return R.failed("标签id、名称不可为空");
          }
          return new R<>(tBusLableService.updateById(tBusLable));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "假删除(yifu-mvp-business:tbuslable_del)", description = "假删除(yifu-mvp-business:tbuslable_del)")
	 @SysLog("假删除B端标签表")
     @DeleteMapping("/{id}")
//     @PreAuthorize("@pms.hasPermission('yifu-mvp-business:tbuslable_del')")
     public R<Boolean> removeById(@PathVariable Integer id) {
          TBusLable tBusLable = new TBusLable();
          tBusLable.setId(id);
          tBusLable.setDeleteFlag(1);
          return new R<>(tBusLableService.updateById(tBusLable));
     }
}
