package com.yifu.cloud.plus.v1.business.mapper.vacation;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.business.entity.vacation.TVacationInfo;
import com.yifu.cloud.plus.v1.business.query.vacation.TVacationInfoQuery;
import com.yifu.cloud.plus.v1.business.vo.vacation.TVacationInfoVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description: 假勤信息表 mapper
 * @Entity com.yifu.cloud.v1.hrobusiness.api.entity.vacation.TVacationInfo
 * @author: huyc
 * @date: 2023/1/13
*/
@Mapper
public interface TVacationInfoMapper extends BaseMapper<TVacationInfo> {

    /**
     * @description: 分页查询: 条件分页查询
     * @param query 查询条件
     * @return: R<IPage<TVacationInfoVO>>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    Page<TVacationInfoVO> getListByPage(Page<TVacationInfoVO> page, @Param("query") TVacationInfoQuery query);

    /**
     * @description: 列表查询查询: 条件列表查询
     * @param query 查询条件
     * @return: List<TVacationInfoVO>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    List<TVacationInfoVO> getListByPage(@Param("query") TVacationInfoQuery query);

    TVacationInfoVO getDataById(@Param("id") String id);
}




