package com.yifu.cloud.plus.v1.business.service.vacation;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.business.dto.vacation.AddOrUpdateTVacationInfoDTO;
import com.yifu.cloud.plus.v1.business.dto.vacation.ChangeVacationStatusDTO;
import com.yifu.cloud.plus.v1.business.dto.vacation.UpdateVacationRedundancyDTO;
import com.yifu.cloud.plus.v1.business.entity.vacation.TVacationInfo;
import com.yifu.cloud.plus.v1.business.query.vacation.TVacationInfoQuery;
import com.yifu.cloud.plus.v1.business.vo.vacation.TVacationInfoVO;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;

import java.util.List;

/**
 * 假勤信息表 service层
 * @author: huyc
 * @date: 2023/1/13
*/
public interface TVacationInfoService extends IService<TVacationInfo> {

    /**
     * 分页查询: 条件分页查询
     * @param query 查询条件
     * @return: R<IPage<TVacationInfoVO>>
	 * @author: huyc
	 * @date: 2023/1/13
    */
    R<IPage<TVacationInfoVO>> getListByPage(TVacationInfoQuery query);

    /**
     * 查询：根据条件出列表
     * @param query 查询条件
     * @return: IPage<com.yifu.cloud.v1.hrobusiness.api.vo.vacation.TVacationInfoVO>>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<List<TVacationInfoVO>> getList(TVacationInfoQuery query);

    /**
     * 查询-详情：根据id查询数据
     * @param id
     * @return: R<TVacationInfoVO>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<TVacationInfoVO> getDataById(String id);

    /**
     * 销假：单条-根据id更新记录
     * @param dto dto
     * @return: R<Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<Boolean> vacationEnd(ChangeVacationStatusDTO dto);

    /**
     * 导入: 通过json串格式导入假勤信息
     * @param jsonStr json字符串数据
     * @return: com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
	R<List<ErrorMessage>> batchImportByJsonStr(String jsonStr);

    /**
     * 删除-单条：根据id删除记录
     * @param id
     * @return: R<Boolean>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<Boolean> removeDataById(String id);

    /**
     * 添加：新增-单条-添加一条记录
     * @param dto
     * @return: R<TVacationInfo>
	 * @author: huyc
	 * @date: 2023/1/13
     */
    R<TVacationInfo> saveData(AddOrUpdateTVacationInfoDTO dto);

    /**
     * @description 更新假勤信息中的冗余信息
	 * @author: huyc
	 * @date: 2023/1/13
     * @param dtoList 更新冗余字段dto集合
     * @return com.yifu.cloud.v1.common.core.util.R<java.lang.Boolean>
     **/
    R<Boolean> updateRedundancyEmployeeFields(List<UpdateVacationRedundancyDTO> dtoList);
}
