package com.yifu.cloud.plus.v1.yifu.common.core.constant;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @Description Excel配置注解自定义接口
 * @author fangxinjiang
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ java.lang.annotation.ElementType.FIELD })
public @interface ExcelAttribute {

    /**
     * Excel中的列名
     *
     * @return
     */
    public abstract String name();

    /**
     * 不好用  建议顺序用表头固定
     * 列名对应的A,B,C,D...,不指定按照默认顺序排序
     *
     * @return
     */
    public abstract String column() default "";



    /**
     * 最大长度校验，默认0无需校验
     * @return
     */
    public abstract int maxLength() default 0;

    /**
     * 最大值
     * @return
     */
    public abstract  String max() default "0";

    /**
     * 最小值
     * @return
     */
    public  abstract  float min() default  0;

    /**
     * 提示信息
     *
     * @return
     */
    public abstract String prompt() default "";

    /**
     * 设置只能选择不能输入的列内容
     *
     * @return
     */
    public abstract String[] combo() default {};

    /**
     * 是否导出数据
     *
     * @return
     */
    public abstract boolean isExport() default true;

    /**
     * 是否为重要字段（整列标红,着重显示）
     *
     * @return
     */
    public abstract boolean isMark() default false;

    /**
     * 是否合计当前列
     *
     * @return
     */
    public abstract boolean isSum() default false;

    /**
     * 是否必填字段
     * @return
     */
    public abstract boolean isNotEmpty() default false;

    /**
     * 是否为电话字段
     * @return
     */
    public abstract boolean isPhone() default false;

    /**
     * 是否为身份证
     * @return
     */
    public abstract boolean isIdCard() default false;

    /**
     * 是否为日期
     * @return
     */
    public abstract  boolean isDate() default  false;

    /**
     * 是否为邮箱
     * @return
     */
    public abstract  boolean isEmail() default  false;
    /**
     * 是否为Integer
     * @return
     */
    public abstract boolean isInteger() default false;

    /**
     * 是否为float
     * @return
     */
    public abstract boolean isFloat() default false;

    /**
     * 是否为double
     * @return
     */
    public abstract boolean isDouble() default false;

    /**
     * 验证表达式
     * @return
     */
    public abstract  String pattern() default  "";

    /**
     * 数据类型标识或字典表CODE 与 isDataId()同步出现
     * 因为字典有的地方有value有的地方用id
     * 建议value不用加后缀 id的后缀加_id
     * 组装map的时候code=值 冗余一遍code_id =值
     * @return
     */
    public  abstract  String dataType() default "";

    /**
     * 读取内容转表达式 (如: 0=男,1=女,2=未知)
     */
    public String readConverterExp() default "";

    /**
     * 日期格式化字符串
     * @return
     */
    public abstract  String dateFormat() default "yyyy-MM-dd";

    /**
     * 日期格式化字符串
     * @return
     */
    public abstract  String dateFormatExport() default "";

    /**
     * 默认错误信息
     * @return
     */
    public abstract  String errorInfo() default "";

    /**
     * 默认错误信息
     * @return
     */
    public abstract  String errorInfoImport() default "";

    /**
     * 是否为实体ID  导入要从字典表取数据 导出要对应导出中文数据
     * @return
     */
    public abstract  boolean isDataId() default  false;
    /**
     * 是否为客户单位和项目实体ID  导入要从字典表取数据 导出要对应导出中文数据
     * @return
     */
    public abstract  boolean isOrgan() default  false;

	/**
	 * 是否转义，默认 true 如果是字典会转义， false不会转义值
	 * @return
	 */
	public abstract  boolean isConvert() default  true;

    /**
     * 是否为区域数据   前提：isDataId = true
     * @Author fxj
     * @Date 2019-09-02
     * @param
     * @return
     **/
    public abstract  boolean isArea() default  false;
    /**
     * 父ID 前提：isDataId = true
     * @Author fxj
     * @Date 2019-09-02
     * @param
     * @return
     **/
    public abstract  String parentField() default "";

    /**
     * 导出字段组合  只用于导出
     * @Author fxj
     * @Date 2019-10-11
     * @param
     * @return
     **/
    public abstract String componentFieldExport() default "";

    /**
     * 用于返回可选择导出的中文字段
     * @param
     * @Author: wangan
     * @Date: 2019/10/17
     * @Description:
     * @return: boolean
     **/
    public abstract boolean needExport() default false;

    /**
     * @param
     * @Author: wangan
     * @Date: 2020/11/5
     * @Description:  字典映射不成功是否展示字典key
     * @return: boolean
     **/
    public abstract boolean noRelationExport() default true;

    /**
     * 是否为实体ID  导入要从字典表取数据 导出要对应导出中文数据
     * @return
     */
    public abstract  String divider() default  "";

    /**
     * @description: 错误信息 需要对字段值提前设置 error= 前缀为错误信息展示为红色， success= 前缀为正确信息展示为绿色
     * @return: boolean 是否开启错误信息展示，对字体颜色进行修改
     * @author: wangweiguo
     * @date: 2021/6/30
     */
    public abstract boolean errorMsg() default false;

}

