package com.yifu.cloud.plus.v1.yifu.common.core.util.equator;

import com.github.dadiyang.equator.Equator;
import com.github.dadiyang.equator.FieldInfo;
import com.github.dadiyang.equator.GetterBaseEquator;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @program: master
 * @description: hr字段比较器 SecondVal空字段忽略
 * @author: pwang
 * @create: 2020-06-24 13:14
 **/
public class HrEquator extends GetterBaseEquator {
    @Override
    protected boolean isFieldEquals(FieldInfo fieldInfo) {
        //空字段空串不更新忽略（单独处理的地方记录）
        /*if(null == fieldInfo.getSecondVal() || (fieldInfo.getSecondVal() instanceof String && "" == ((String) fieldInfo.getSecondVal()).trim())){
            return true;
        }*/
        if (fieldInfo.getFirstVal() instanceof BigDecimal) {
            BigDecimal first = (BigDecimal) fieldInfo.getFirstVal();
            BigDecimal second = (BigDecimal) fieldInfo.getSecondVal();

            if (null != second && first.compareTo(second) == CommonConstants.dingleDigitIntArray[0]) {
                return true;
            }else{
                return false;
            }
        }
        return super.isFieldEquals(fieldInfo);
    }
    /**
     * 比较对象的差异，返回差异的属性名
     * @Author huyc
     * @Date 2022-06-22 11:32
     * @param oldInfo
     * @param newInfo
     * @return
     **/
    public static String comparisonValue(Object oldInfo, Object newInfo){
		StringBuilder sb = new StringBuilder(CommonConstants.EMPTY_STRING);
        Equator equator = new HrEquator();
        // 获取不同的属性
        List<FieldInfo> diff = equator.getDiffFields(oldInfo, newInfo);
		Map<String, Integer> curMap = new HashMap<>();
		String fieldName;
		String fieldName2;
		boolean newChange = false;
        if (!Common.isEmpty(diff)) {
			List<FieldInfo> diff2;
            for(FieldInfo field:diff){
				fieldName = field.getFieldName();
				curMap.put(fieldName, 1);
				if (!"updateTime".equals(fieldName) && !"updateBy".equals(fieldName) && !"java.util.List".equals(field.getFirstFieldType().getName())) {
					newChange = true;
					sb.append(field.getFieldName()).append(",");
				}
				try {
					if ("java.util.List".equals(field.getFirstFieldType().getName())) {
						List<Object> firstList = (List<Object>) field.getFirstVal();
						List<Object> secondList = (List<Object>) field.getSecondVal();
						curMap.put(fieldName, 1);
						if (firstList != null && secondList != null && !firstList.isEmpty()) {
							if (firstList.size() == secondList.size()) {
								boolean isTrue = true;
								for (int i = 0; i < firstList.size(); i++) {
									if (isTrue) {
										diff2 = equator.getDiffFields(firstList.get(i), secondList.get(i));
										for (FieldInfo field2 : diff2) {
											fieldName2 = field2.getFieldName();
											if (!"createTime".equals(fieldName2) && !"createBy".equals(fieldName2) && !"createName".equals(fieldName2)
													&& !"updateTime".equals(fieldName2) && !"updateBy".equals(fieldName2)) {
												newChange = true;
												sb.append(field.getFieldName()).append(",");
												isTrue = false;
												break;
											}
										}
									}
								}
							} else {
								newChange = true;
								sb.append(field.getFieldName()).append(",");
							}
						} else if ((firstList != null && !firstList.isEmpty()) || (secondList != null && !secondList.isEmpty())) {
							newChange = true;
							sb.append(field.getFieldName()).append(",");
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
            }
        }
		// 从有值变为空，也要记录变更日志
		List<FieldInfo> diff2 = equator.getDiffFields(newInfo, oldInfo);
        if (!Common.isEmpty(diff2)) {
            for(FieldInfo field:diff2){
				fieldName = field.getFieldName();
				if (curMap.get(fieldName) == null && !"updateTime".equals(field.getFieldName()) && !"updateBy".equals(field.getFieldName())) {
					newChange = true;
					sb.append(field.getFieldName()).append(",");
				}
            }
        }
		if (newChange) {
			sb.deleteCharAt(sb.length()-1);
		}
		return sb.toString();
    }
	private static boolean ignoreField(String fieldName, List<String> ignoreField){
		if (Common.isNotNull(ignoreField)){
			for(String fd:ignoreField){
				if (fieldName.equals(fd)){
					return true;
				}
			}
		}
		return false;
	}
	/**
	 * 比较对象的差异，返回差异的属性名
	 * @Author huyc
	 * @Date 2022-06-22 11:32
	 * @param oldInfo
	 * @param newInfo
	 * @return
	 **/
	public static String comparisonValueIgnoreField(Object oldInfo, Object newInfo,List<String> ignoreField){
		StringBuilder sb = new StringBuilder(CommonConstants.EMPTY_STRING);
		Equator equator = new HrEquator();
		// 获取不同的属性
		List<FieldInfo> diff = equator.getDiffFields(oldInfo, newInfo);
		Map<String, Integer> curMap = new HashMap<>();
		String fieldName;
		String fieldName2;
		boolean newChange = false;
		if (!Common.isEmpty(diff)) {
			List<FieldInfo> diff2;
			for(FieldInfo field:diff){
				fieldName = field.getFieldName();
				if (ignoreField(fieldName,ignoreField)){
					continue;
				}
				curMap.put(fieldName, 1);
				if (!"updateTime".equals(fieldName) && !"updateBy".equals(fieldName) && !"java.util.List".equals(field.getFirstFieldType().getName())) {
					newChange = true;
					sb.append(field.getFieldName()).append(",");
				}
				try {
					if ("java.util.List".equals(field.getFirstFieldType().getName())) {
						List<Object> firstList = (List<Object>) field.getFirstVal();
						List<Object> secondList = (List<Object>) field.getSecondVal();
						curMap.put(fieldName, 1);
						if (firstList != null && secondList != null && !firstList.isEmpty()) {
							if (firstList.size() == secondList.size()) {
								boolean isTrue = true;
								for (int i = 0; i < firstList.size(); i++) {
									if (isTrue) {
										diff2 = equator.getDiffFields(firstList.get(i), secondList.get(i));
										for (FieldInfo field2 : diff2) {
											fieldName2 = field2.getFieldName();
											if (!"createTime".equals(fieldName2) && !"createBy".equals(fieldName2) && !"createName".equals(fieldName2)
													&& !"updateTime".equals(fieldName2) && !"updateBy".equals(fieldName2)) {
												newChange = true;
												sb.append(field.getFieldName()).append(",");
												isTrue = false;
												break;
											}
										}
									}
								}
							} else {
								newChange = true;
								sb.append(field.getFieldName()).append(",");
							}
						} else if ((firstList != null && !firstList.isEmpty()) || (secondList != null && !secondList.isEmpty())) {
							newChange = true;
							sb.append(field.getFieldName()).append(",");
						}
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}
		// 从有值变为空，也要记录变更日志
		List<FieldInfo> diff2 = equator.getDiffFields(newInfo, oldInfo);
		if (!Common.isEmpty(diff2)) {
			for(FieldInfo field:diff2){
				fieldName = field.getFieldName();
				if (ignoreField(fieldName,ignoreField)){
					continue;
				}
				if (curMap.get(fieldName) == null && !"updateTime".equals(field.getFieldName()) && !"updateBy".equals(field.getFieldName())) {
					newChange = true;
					sb.append(field.getFieldName()).append(",");
				}
			}
		}
		if (newChange) {
			sb.deleteCharAt(sb.length()-1);
		}
		return sb.toString();
	}

	/**
	 * 比较对象的差异，返回差异的属性名
	 * @Author pwang
	 * @Date 2020-06-18 15:32
	 * @param oldInfo
	 * @param newInfo
	 * @param differenceKey
	 * @return
	 **/
	public static String comparisonValue(Object oldInfo, Object newInfo, String differenceKey){
		//防止new StringBuffer时空指针
		if(null == differenceKey){
			differenceKey = "";
		}
		StringBuilder sb = new StringBuilder(differenceKey);
		Equator equator = new HrEquator();
		// 获取不同的属性
		List<FieldInfo> diff = equator.getDiffFields(oldInfo, newInfo);
		if(Common.isNotNull(diff)){
			for(FieldInfo field:diff){
				sb.append(field.getFieldName()).append(",");
			}
			sb.deleteCharAt(sb.length()-1);
		}
		return sb.toString();
	}

}
