package com.yifu.cloud.plus.v1.yifu.common.dapr.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * @Author fxj
 * @Description 客户服务平台 dapr 配置
 * @Date 11:55 2025/2/25
 * @Param
 * @return
**/
@Data
@Component
@PropertySource("classpath:daprConfig.properties")
@ConfigurationProperties(value = "dapr.csp", ignoreInvalidFields = false)
public class DaprCspProperties {
	/*
	 * @author fxj
	 * @date  14:34
	 * @Description  dapr sidercar url  如：http://localhost:3005/v1.0/invoke/
	 **/
	String appUrl;
	/*
	 * @author fxj
	 * @date  14:35
	 * @decription  app_id  如："yifu_upms_sider"
	 **/
	String appId;

	String appPort;

	String httpPort;

	String grpcPort;

	String metricsPort;
}
