package com.yifu.cloud.plus.v1.yifu.common.dapr.util;

import com.alibaba.fastjson.JSON;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.SecurityConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.dapr.config.DaprSalaryProperties;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.EkpSocialViewVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import java.util.List;

/**
 * @Author fxj
 * @Date 2022/8/17
 * @Description
 * @Version 1.0
 */
@Log4j2
@EnableConfigurationProperties(DaprSalaryProperties.class)
public class SalaryDaprUtil {
	@Autowired
	private DaprSalaryProperties daprProperties;

	/**
	 * @Author huyc
	 * @Description 更新结算信息
	 * @Date 17:38 2022/12/26
	 * @Param
	 * @return
	 **/
	public R<Boolean> updateSalarySettleStatus(List<EkpSocialViewVo> infoVo) {
		return HttpDaprUtil.invokeMethodPost(daprProperties.getAppUrl(),daprProperties.getAppId(),"/tsalaryaccount/inner/updateSalarySettleStatus", JSON.toJSONString(infoVo), Boolean.class, SecurityConstants.FROM_IN);
	}
}
