/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;

/**
 * 发放日志明细(银企付款任务)
 *
 * @author hgw
 * @date 2024-11-15 17:12:14
 */
@Data
@TableName("ekp_bank_grant_log_detail")
@Schema(description = "发放日志明细(银企付款任务)")
public class EkpBankGrantLogDetail {

	/**
	 * fdId
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("fdId")
	@Schema(description = "fdId")
	private String fdId;
	/**
	 * 发放日志关联主键
	 */
	@ExcelAttribute(name = "发放日志关联主键", isNotEmpty = true, errorInfo = "发放日志关联主键不能为空", maxLength = 36)
	@NotBlank(message = "发放日志关联主键不能为空")
	@Length(max = 36, message = "发放日志关联主键不能超过36个字符")
	@ExcelProperty("发放日志关联主键")
	@Schema(description = "发放日志关联主键")
	private String fdParentId;
	/**
	 * 收款人名称
	 */
	@ExcelAttribute(name = "收款人名称", maxLength = 50)
	@Length(max = 50, message = "收款人名称不能超过50个字符")
	@ExcelProperty("收款人名称")
	@Schema(description = "收款人名称")
	private String fdPayee;
	/**
	 * 收款账号
	 */
	@ExcelAttribute(name = "收款账号", maxLength = 50)
	@Length(max = 50, message = "收款账号不能超过50个字符")
	@ExcelProperty("收款账号")
	@Schema(description = "收款账号")
	private String fdPayeeAccount;
	/**
	 * 金额
	 */
	@ExcelAttribute(name = "金额")
	@ExcelProperty("金额")
	@Schema(description = "金额")
	private BigDecimal fdMoney;
	/**
	 * 收款银行
	 */
	@ExcelAttribute(name = "收款银行", maxLength = 100)
	@Length(max = 100, message = "收款银行不能超过100个字符")
	@ExcelProperty("收款银行")
	@Schema(description = "收款银行")
	private String fdRecipientBank;
	/**
	 * 汇款用途：工资等
	 */
	@ExcelAttribute(name = "汇款用途：工资等", maxLength = 10)
	@Length(max = 10, message = "汇款用途：工资等不能超过10个字符")
	@ExcelProperty("汇款用途：工资等")
	@Schema(description = "汇款用途：工资等")
	private String fdRemittancePurpose;
	/**
	 * 备注
	 */
	@ExcelAttribute(name = "备注", maxLength = 500)
	@Length(max = 500, message = "备注不能超过500个字符")
	@ExcelProperty("备注")
	@Schema(description = "备注")
	private String fdRemark;
	/**
	 * 指令状态
	 */
	@ExcelAttribute(name = "指令状态", maxLength = 20)
	@Length(max = 20, message = "指令状态不能超过20个字符")
	@ExcelProperty("指令状态")
	@Schema(description = "指令状态")
	private String fdCommandStatus;

}
