/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 银企付款任务主表信息
 *
 * @author hgw
 * @date 2024-11-15 17:12:14
 */
@Data
@TableName("ekp_bank_pay_task")
@Schema(description = "银企付款任务主表信息")
public class EkpBankPayTask {

	/**
	 * 主键ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("主键ID")
	@Schema(description = "主键ID")
	private String fdId;
	/**
	 * 客户名称
	 */
	@ExcelAttribute(name = "客户名称", maxLength = 100)
	@Length(max = 100, message = "客户名称不能超过100个字符")
	@ExcelProperty("客户名称")
	@Schema(description = "客户名称")
	private String fdCustomerName;
	/**
	 * 项目名称
	 */
	@ExcelAttribute(name = "项目名称", maxLength = 100)
	@Length(max = 100, message = "项目名称不能超过100个字符")
	@ExcelProperty("项目名称")
	@Schema(description = "项目名称")
	private String fdProjectName;
	/**
	 * 项目编码
	 */
	@ExcelAttribute(name = "项目编码", maxLength = 20)
	@Length(max = 20, message = "项目编码不能超过20个字符")
	@ExcelProperty("项目编码")
	@Schema(description = "项目编码")
	private String fdProjectCode;
	/**
	 * 省
	 */
	@ExcelAttribute(name = "省", maxLength = 100)
	@Length(max = 100, message = "省不能超过100个字符")
	@ExcelProperty("省")
	@Schema(description = "省")
	private String fdProvince;
	/**
	 * 市
	 */
	@ExcelAttribute(name = "市", maxLength = 100)
	@Length(max = 100, message = "市不能超过100个字符")
	@ExcelProperty("市")
	@Schema(description = "市")
	private String fdCity;
	/**
	 * 县/区
	 */
	@ExcelAttribute(name = "县/区", maxLength = 100)
	@Length(max = 100, message = "县/区不能超过100个字符")
	@ExcelProperty("县/区")
	@Schema(description = "县/区")
	private String fdTown;
	/**
	 * 金额
	 */
	@ExcelAttribute(name = "金额")
	@ExcelProperty("金额")
	@Schema(description = "金额")
	private BigDecimal fdMoney;
	/**
	 * 支付类别：工资、社保
	 */
	@ExcelAttribute(name = "支付类别：工资、社保", maxLength = 30)
	@Length(max = 30, message = "支付类别：工资、社保不能超过30个字符")
	@ExcelProperty("支付类别：工资、社保")
	@Schema(description = "支付类别：工资、社保")
	private String fdPayType;
	/**
	 * 付款银行名称
	 */
	@ExcelAttribute(name = "付款银行名称", maxLength = 100)
	@Length(max = 100, message = "付款银行名称不能超过100个字符")
	@ExcelProperty("付款银行名称")
	@Schema(description = "付款银行名称")
	private String fdBankName;
	/**
	 * 付款银行开户行
	 */
	@ExcelAttribute(name = "付款银行开户行", maxLength = 100)
	@Length(max = 100, message = "付款银行开户行不能超过100个字符")
	@ExcelProperty("付款银行开户行")
	@Schema(description = "付款银行开户行")
	private String fdBankNo;
	/**
	 * 付款银行账户
	 */
	@ExcelAttribute(name = "付款银行账户", maxLength = 30)
	@Length(max = 30, message = "付款银行账户不能超过30个字符")
	@ExcelProperty("付款银行账户")
	@Schema(description = "付款银行账户")
	private String fdBankAccount;
	/**
	 * 前端客服
	 */
	@ExcelAttribute(name = "前端客服", maxLength = 30)
	@Length(max = 30, message = "前端客服不能超过30个字符")
	@ExcelProperty("前端客服")
	@Schema(description = "前端客服")
	private String fdCustomerServer;
	/**
	 * 创建者
	 */
	@ExcelAttribute(name = "创建者", maxLength = 30)
	@Length(max = 30, message = "创建者不能超过30个字符")
	@ExcelProperty("创建者")
	@Schema(description = "创建者")
	private String fdCreater;
	/**
	 * 发放状态:待发放、发放中、已发放
	 */
	@ExcelAttribute(name = "发放状态:待发放、发放中、已发放", maxLength = 20)
	@Length(max = 20, message = "发放状态:待发放、发放中、已发放不能超过20个字符")
	@ExcelProperty("发放状态:待发放、发放中、已发放")
	@Schema(description = "发放状态:待发放、发放中、已发放")
	private String fdGrantStatus;
	/**
	 * 提交出纳
	 */
	@ExcelAttribute(name = "提交出纳", maxLength = 20)
	@Length(max = 20, message = "提交出纳不能超过20个字符")
	@ExcelProperty("提交出纳")
	@Schema(description = "提交出纳")
	private String fdSubmitCashier;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@ExcelProperty("创建时间")
	@Schema(description = "创建时间")
	private LocalDateTime fdCreateTime;
	/**
	 * 结算单号
	 */
	@ExcelAttribute(name = "结算单号", isNotEmpty = true, errorInfo = "结算单号不能为空", maxLength = 20)
	@NotBlank(message = "结算单号不能为空")
	@Length(max = 20, message = "结算单号不能超过20个字符")
	@ExcelProperty("结算单号")
	@Schema(description = "结算单号")
	private String fdSettlementNo;
	/**
	 * 结算单ID 页面跳转使用
	 */
	@ExcelAttribute(name = "结算单ID 页面跳转使用", isNotEmpty = true, errorInfo = "结算单ID 页面跳转使用不能为空", maxLength = 36)
	@NotBlank(message = "结算单ID 页面跳转使用不能为空")
	@Length(max = 36, message = "结算单ID 页面跳转使用不能超过36个字符")
	@ExcelProperty("结算单ID 页面跳转使用")
	@Schema(description = "结算单ID 页面跳转使用")
	private String fdSettlementId;
	/**
	 * 发放失败处理状态：待发放、发放中、已处理、转手工
	 */
	@ExcelAttribute(name = "发放失败处理状态：待发放、发放中、已处理、转手工", maxLength = 10)
	@Length(max = 10, message = "发放失败处理状态：待发放、发放中、已处理、转手工不能超过10个字符")
	@ExcelProperty("发放失败处理状态：待发放、发放中、已处理、转手工")
	@Schema(description = "发放失败处理状态：待发放、发放中、已处理、转手工")
	private String fdFailHandleStatus;
	/**
	 * 附件ID
	 */
	@ExcelAttribute(name = "附件ID", maxLength = 36)
	@Length(max = 36, message = "附件ID不能超过36个字符")
	@ExcelProperty("附件ID")
	@Schema(description = "附件ID")
	private String fdAttaId;
	/**
	 * 附件名称
	 */
	@ExcelAttribute(name = "附件名称", maxLength = 200)
	@Length(max = 200, message = "附件名称不能超过200个字符")
	@ExcelProperty("附件名称")
	@Schema(description = "附件名称")
	private String fdAttaName;
	/**
	 * 附件资源路径
	 */
	@ExcelAttribute(name = "附件资源路径", maxLength = 200)
	@Length(max = 200, message = "附件资源路径不能超过200个字符")
	@ExcelProperty("附件资源路径")
	@Schema(description = "附件资源路径")
	private String fdAttaSrc;
	/**
	 * 附件下载次数
	 */
	@ExcelAttribute(name = "附件下载次数")
	@ExcelProperty("附件下载次数")
	@Schema(description = "附件下载次数")
	private Integer fdDownloadNum;
	/**
	 * 失败次数
	 */
	@ExcelAttribute(name = "失败次数")
	@ExcelProperty("失败次数")
	@Schema(description = "失败次数")
	private Integer fdFailNum;
	/**
	 * 发放次数
	 */
	@ExcelAttribute(name = "发放次数")
	@ExcelProperty("发放次数")
	@Schema(description = "发放次数")
	private Integer fdGrantNum;

	@ExcelAttribute(name = "批次号", maxLength = 36)
	@Length(max = 36, message = "批次号不能超过36个字符")
	@ExcelProperty("批次号")
	@Schema(description = "批次号")
	private String fdWxNo;

	@ExcelAttribute(name = "MD码", maxLength = 100)
	@Length(max = 100, message = "MD码不能超过100个字符")
	@ExcelProperty("MD码")
	@Schema(description = "MD码")
	private String fdMdCode;

	@ExcelAttribute(name = "失败原因", maxLength = 500)
	@Length(max = 500, message = "失败原因不能超过500个字符")
	@ExcelProperty("失败原因")
	@Schema(description = "失败原因")
	private String fdErrorMsg;

	// 明细条数
	@TableField(exist = false)
	private String num;

}
