package com.yifu.cloud.plus.v1.ekp.controller;

import com.icbc.api.IcbcApiException;
import com.yifu.cloud.plus.v1.ekp.entity.EkpBankCodeSet;
import com.yifu.cloud.plus.v1.ekp.service.IcbcTransactionFlowQueryService;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 聚富通到账通知交易流水查询
 *
 * @author huyc
 * @date 2024-05-23 10:24:12
 */
@Log4j2
@RestController
@RequiredArgsConstructor
@RequestMapping("/icbcQuery" )
@Tag(name = "聚富通到账通知交易流水查询")
public class IcbcTransactionFlowQueryController {

	private final IcbcTransactionFlowQueryService icbcTransactionFlowQueryService;

	/**
	 * 管家卡交易流水查询
	 *
	 * @param
	 * @return
	 */
	@Operation(summary = "管家卡交易流水查询", description = "交管家卡易流水查询")
	@PostMapping("/page")
	public R getIcbcTransactionFlow() {
		return icbcTransactionFlowQueryService.getIcbcTransactionFlow();
	}

	/**
	 * 交易流水查询
	 *
	 * @param
	 * @return
	 */
	@Operation(summary = "交易流水查询", description = "交易流水查询")
	@PostMapping("/newPage")
	public R getIcbcTransactionFlowNew() throws IcbcApiException {
		return icbcTransactionFlowQueryService.getIcbcTransactionFlowNew();
	}

	/**
	 * 交易流水查询
	 *
	 * @param
	 * @return
	 */
	@Operation(summary = "交易流水查询", description = "交易流水查询")
	@Inner
	@PostMapping("/inner/newPage")
	public R getIcbcTransactionFlowInner() throws IcbcApiException {
		log.info("开始交易流水查询");
		return icbcTransactionFlowQueryService.getIcbcTransactionFlowNew();
	}

	/**
	 * 查询昨日交易流水
	 *
	 * @param
	 * @return
	 */
	@Operation(summary = "查询昨日交易流水", description = "查询昨日交易流水")
	@Inner
	@PostMapping("/inner/newPageYesterday")
	public R getIcbcTransactionFlowYesterdayInner() throws IcbcApiException {
		return icbcTransactionFlowQueryService.getIcbcTransactionFlowYesterdayInner();
	}

	/**
	 * 预订单接口
	 *
	 * @param
	 * @return
	 */
	@Operation(summary = "预订单接口", description = "预订单接口")
	@PostMapping("/save")
	public R saveIcbcManagerCard() {
		return icbcTransactionFlowQueryService.saveIcbcManagerCard();
	}

	/**
	 * 行名行号查询接口
	 *
	 * @param
	 * @param
	 * @return
	 */
	@Operation(summary = "行名行号查询接口", description = "行名行号查询接口")
	@PostMapping("/querybankinfo")
	public R<EkpBankCodeSet> querybankinfo(@RequestParam(required = false) String cardNo) {
		if (Common.isEmpty(cardNo)) {
			cardNo = "6217752510002149161";
		}
		return icbcTransactionFlowQueryService.querybankinfo(cardNo);
	}

	/**
	 * 指令对账单明细下载
	 *
	 * @param
	 * @param
	 * @return
	 */
	@Operation(summary = "指令对账单明细下载", description = "指令对账单明细下载")
	@PostMapping("/enterprisePayDowninstr")
	public R getEnterprisePayDowninstr() {
		return icbcTransactionFlowQueryService.getEnterprisePayDowninstr();
	}

	/**
	 * 电子回单下载功能
	 *
	 * @param
	 * @param
	 * @return
	 */
	@Operation(summary = "电子回单下载功能", description = "电子回单下载功能")
	@PostMapping("/entermeatebillreceive")
	public R getMeatebillreceive() {
		return icbcTransactionFlowQueryService.getMeatebillreceive();
	}
}
