package com.yifu.cloud.plus.v1.ekp.controller;

import com.yifu.cloud.plus.v1.ekp.service.EkpSalaryInfoService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.ErrorMessage;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import com.yifu.cloud.plus.v1.yifu.ekp.vo.EkpSalaryParam;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.SneakyThrows;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;


/**
 * 工资明细推送
 * @author huyc
 * @date 2024-03-11 10:04:12
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/ekpSalaryPush" )
@Tag(name = "工资明细推送")
public class TEkpSalaryInfoController {

	private final EkpSalaryInfoService salaryInfoService;

	/**
	 * @param unPushList
	 * @Description: 推送工资明细数据
	 * @Author: huyc
	 * @Date: 2024/2/29
	 * @return:
	 **/
	@Inner
	@PostMapping("/inner/pushSalaryInfoToEkp")
	public Boolean pushSalaryInfoToEkp(@RequestBody List<EkpSalaryParam> unPushList) {
		return salaryInfoService.pushSalaryInfoToEkp(unPushList);
	}

	/**
	 * 差额费导入
	 *
	 * @author huyc
	 * @date 2024-7-4
	 **/
	@SneakyThrows
	@Operation(description = "差额费导入")
	@SysLog("差额费导入")
	@PostMapping("/importClaimInfo")
	public R<List<ErrorMessage>> importClaimInfo(@RequestBody MultipartFile file) {
		YifuUser user = SecurityUtils.getUser();
		if (Common.isEmpty(user)){
			return R.failed(CommonConstants.USER_FAIL);
		}
		return salaryInfoService.importClaimInfo(file.getInputStream());
	}
}
