/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.ekp.entity.EkpBankGrantDetail;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankCodeConfiglVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankExcelVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 发放结果明细(银企付款任务)
 *
 * @author hgw
 * @date 2024-11-15 17:12:14
 */
public interface EkpBankGrantDetailService extends IService<EkpBankGrantDetail> {

	// 查询待发条数
	int getCountByIdAndMain(String fdParentId);

	// 查询下载的待发 明细数据
	List<EkpBankExcelVo> getEkpBankExcelVoByIdAndMain(String fdParentId);

	// 查询下载的待发 明细数据
	List<EkpBankExcelVo> getEkpBankExcelVoByIdAndDetail(String fdId);

	// 查询编码是否重复
	String getWxNoByWxNo(String wxNo);

	// 主表发放时，更新明细表的发放时间与状态
	void updateStatusByGrant(String fdParentId);

	// 发放失败，批量更新中信银行交易流水表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	void updateZhongXinStatus(String salaryId, String detailId, String detailFailMsg);
	void updateZhongXinMainStatus(String salaryId, String detailId, String detailFailMsg);

	// 明细再次-发放失败，批量更新中信银行交易流水表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	void updateZhongXinStatusAndBankInfo(List<String> salaryIdList);
	void updateZhongXinMainStatusAndBankInfo(List<String> salaryIdList);

	// 主表拒绝授权时，批量更新明细表为发放失败，原因为拒绝授权
	void updateStatusByGrantFail(String fdParentId);

	// 获取明细表ID来更新状态
	List<EkpBankGrantDetail> getListByParentId(String fdParentId);

	// 获取工行开户行配置表
	Map<String, EkpBankCodeConfiglVo> getEkpBankCodeConfiglVo();

	/**
	 * @param fdId 工资支出 表id
	 * @param chuNaName 银企出纳名字
	 * @Description: 更新 工资支出 的 银企出纳名字
	 * @Author: hgw
	 * @Date: 2024/12/26 11:41
	 * @return: void
	 **/
	void updateGongZiZhiChuTable(String fdId, String chuNaName);
	/**
	 * @param fdId 工资支出 表id
	 * @param chuNaName 银企出纳名字
	 * @Description: 更新 工资支出Main表 的 银企出纳名字
	 * @Author: hgw
	 * @Date: 2024/12/26 11:41
	 * @return: void
	 **/
	void updateGongZiZhiChuMain(String fdId, String chuNaName);

}
