/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.ekp.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.ekp.entity.EkpBankPayTask;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankResultVo;

import java.util.List;

/**
 * 银企付款任务主表信息
 *
 * @author hgw
 * @date 2024-11-15 17:12:14
 */
public interface EkpBankPayTaskService extends IService<EkpBankPayTask> {

	/**
	 * @Description: 获取发放中的主表，查询结果
	 * @Author: hgw
	 * @Date: 2024-11-25 10:25:58
	 * @return: com.yifu.cloud.plus.v1.ekp.entity.EkpBankPayTask
	 **/
	List<EkpBankResultVo> getEkpBankMainByNeedResultMain();

	/**
	 * @Description: 获取发放中的明细表，查询结果
	 * @Author: hgw
	 * @Date: 2024/11/25 10:38
	 * @return: java.util.List<com.yifu.cloud.plus.v1.ekp.vo.EkpBankResultVo>
	 **/
	List<EkpBankResultVo> getEkpBankMainByNeedResultDetail();

}
