/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */
package com.yifu.cloud.plus.v1.ekp.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.yifu.cloud.plus.v1.ekp.entity.EkpBankGrantDetail;
import com.yifu.cloud.plus.v1.ekp.mapper.EkpBankGrantDetailMapper;
import com.yifu.cloud.plus.v1.ekp.service.EkpBankGrantDetailService;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankCodeConfiglVo;
import com.yifu.cloud.plus.v1.ekp.vo.EkpBankExcelVo;
import lombok.extern.log4j.Log4j2;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 发放结果明细(银企付款任务)
 *
 * @author hgw
 * @date 2024-11-15 17:12:14
 */
@Log4j2
@Service
public class EkpBankGrantDetailServiceImpl extends ServiceImpl<EkpBankGrantDetailMapper, EkpBankGrantDetail> implements EkpBankGrantDetailService {


	@Override
	public int getCountByIdAndMain(String fdParentId) {
		return baseMapper.getCountByIdAndMain(fdParentId);
	}

	@Override
	public List<EkpBankExcelVo> getEkpBankExcelVoByIdAndMain(String fdParentId) {
		return baseMapper.getEkpBankExcelVoByIdAndMain(fdParentId);
	}

	@Override
	public List<EkpBankExcelVo> getEkpBankExcelVoByIdAndDetail(String fdId) {
		return baseMapper.getEkpBankExcelVoByIdAndDetail(fdId);
	}

	@Override
	public String getWxNoByWxNo(String wxNo) {
		return baseMapper.getWxNoByWxNo(wxNo);
	}

	@Override
	public void updateStatusByGrant(String fdParentId) {
		baseMapper.updateStatusByGrant(fdParentId);
	}

	// 发放失败，批量更新中信银行交易流水表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	@Override
	public void updateZhongXinStatus(String salaryId, String detailId, String detailFailMsg) {
		baseMapper.updateZhongXinStatus(salaryId, detailId, detailFailMsg);
	}

	// 发放失败，批量更新中信银行交易流水表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	@Override
	public void updateZhongXinMainStatus(String salaryId, String detailId, String detailFailMsg) {
		baseMapper.updateZhongXinMainStatus(salaryId, detailId, detailFailMsg);
	}

	// 明细再次-发放失败，批量更新中信银行交易流水表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	@Override
	public void updateZhongXinStatusAndBankInfo(List<String> salaryIdList) {
		baseMapper.updateZhongXinStatusAndBankInfo(salaryIdList);
	}

	// 明细再次-发放失败，批量更新中信银行交易流水表fd_3b148bc0c28e48为失败，根据 工资明细fdId：fd_3b1fe00b0f5dde
	@Override
	public void updateZhongXinMainStatusAndBankInfo(List<String> salaryIdList) {
		baseMapper.updateZhongXinMainStatusAndBankInfo(salaryIdList);
	}

	@Override
	public void updateStatusByGrantFail(String fdParentId) {
		baseMapper.updateStatusByGrantFail(fdParentId);
	}

	@Override
	public List<EkpBankGrantDetail> getListByParentId(String fdParentId) {
		return baseMapper.getListByParentId(fdParentId);
	}

	/**
	 * @Description: 获取工行开户行配置表
	 * @Author: hgw
	 * @Date: 2024/12/25 16:10
	 * @return: java.util.Map<java.lang.String, com.yifu.cloud.plus.v1.ekp.vo.EkpBankCodeConfiglVo>
	 **/
	@Override
	public Map<String, EkpBankCodeConfiglVo> getEkpBankCodeConfiglVo() {
		Map<String, EkpBankCodeConfiglVo> returnMap = new HashMap<>();
		// getBankNameMvp 是非空切唯一的，可以做key
		List<EkpBankCodeConfiglVo> list = baseMapper.getEkpBankCodeConfiglVo();
		if (list != null && !list.isEmpty()) {
			for (EkpBankCodeConfiglVo vo : list) {
				returnMap.put(vo.getBankNameMvp(), vo);
			}
		}
		return returnMap;
	}

	@Override
	public void updateGongZiZhiChuTable(String fdId, String chuNaName) {
		baseMapper.updateGongZiZhiChuTable(fdId, chuNaName);
	}

	@Override
	public void updateGongZiZhiChuMain(String fdId, String chuNaName) {
		baseMapper.updateGongZiZhiChuMain(fdId, chuNaName);
	}


}
