package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;

/**
 * ekp交互失败存储表
 * @TableName t_insurance_ekp
 */
@Data
@Tag(name = "ekp交互失败存储表")
public class TInsuranceEkp implements Serializable {
    /**
     * 主键id
     */
	@TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 商险id
     */
    private String detailId;

    /**
     * 结算id
     */
    private String defaultSettleId;

	/**
	 * 单据类型 (0、与薪资合并结算 1、单独结算)
	 */
	private String settleType;

    /**
     * 项目编码
     */
    private String deptNo;

    /**
     * 项目名称
     */
    private String deptName;

    /**
     * 客户名称
     */
    private String customerName;

    /**
     * 客户编码
     */
    private String customerCode;

    /**
     * 员工姓名
     */
    private String empName;

    /**
     * 员工身份证号
     */
    private String empIdcardNo;

    /**
     * 发票号
     */
    private String invoiceNo;

    /**
     * 发生日期
     */
    private Date happenDate;

    /**
     * 保单编号
     */
    private String policyNo;

    /**
     * 保险公司名称
     */
    private String insuranceCompanyName;

    /**
     * 险种名称
     */
    private String insuranceTypeName;

    /**
     * 保单开始时间
     */
    private LocalDate policyStart;

    /**
     * 保单结束时间
     */
    private LocalDate policyEnd;

    /**
     * 购买标准
     */
    private String buyStandard;

    /**
     * 医疗额度
     */
    private String medicalQuota;

    /**
     * 身故或残疾额度
     */
    private String dieDisableQuota;

    /**
     * 实际保费
     */
    private BigDecimal actualPremium;

    /**
     * 预估保费
     */
    private BigDecimal estimatePremium;

    /**
     * 结算月
     */
    private String settleMonth;

    /**
     * 单据状态
     */
    private String interactiveType;

    /**
     * 重发标识
     */
    private Integer resendFlag;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 发送时间
     */
    private LocalDateTime pushTime;

	/**
	 * 	EKP推送类型
	 */
	@Schema(description = "推送类型（1推送预估费用,2推送实缴费用,3变更结算信息,4推送作废信息,5推送预估红冲信息,6推送实缴红冲信息）")
	private Integer pushType;

	/**
	 * 不重发原因
	 */
	@Schema(description = "不重发原因")
	private String notResendMessage;

	/**
	 * EKP的 是否BPO：  是  否
	 */
	@Schema(description = "是否BPO", name = "bpoFlag")
	private String bpoFlag;
    private static final long serialVersionUID = 1L;

}