package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDate;

/**
 * @author licancan
 * @description 保单号对应起止时间表 t_insurance_policy
 * @date 2022-12-07 16:40:16
 */
@Schema(description = "保单号对应起止时间表")
@Data
public class TInsurancePolicy extends BaseEntity {
    /**
     * 主键
     */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;

    /**
     * 保单编号
     */
	@Schema(description = "保单编号")
    private String policyNo;

	/**
	 * 保单开始时间
	 */
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;

    /**
     * 保险公司名称
     */
	@Schema(description = "保险公司名称")
    private String insuranceCompanyName;

    /**
     * 险种名称
     */
	@Schema(description = "险种名称")
    private String insuranceTypeName;

    /**
     * 是否启用标识 0启用 1未启用
     */
	@Schema(description = "是否启用标识 0启用 1未启用")
    private Integer enableFlag;

    /**
     * 是否删除 0未删除 1删除
     */
	@Schema(description = "是否删除 0未删除 1删除")
    private Integer deleteFlag;

	/**
	 * 购买月数
	 */
	@TableField(exist = false)
	@Schema(description = "购买月数")
	private Long buyMonth;


    @TableField(exist = false)
    private static final long serialVersionUID = 1L;

}