package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 结算信息作废记录表（用于记录项目变更导致推信息送至EKP）
 * @TableName t_insurance_settle_cancel
 */
@Data
@Tag(name = "结算信息作废记录")
public class TInsuranceSettleCancel implements Serializable {
    /**
     * id
     */
	@TableId(type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 结算明细id
     */
    private String insDetailId;

    /**
     * 结算信息表id
     */
    private String settleId;

    /**
     * 项目编码
     */
    private String deptNo;

    /**
     * 项目名称
     */
    private String deptName;
    /**
     * 推送标识 未推送，1成功 0失败
     */
    private Integer isCancelPush;

    /**
     * 创建时间
     */
    private LocalDateTime createTime;

    /**
     * 操作人
     */
    private String createUesr;

    private static final long serialVersionUID = 1L;

}