/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.insurances.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 同步结算状态的错误表
 *
 * @author huyc
 * @date 2023-01-11 10:26:30
 */
@Data
@TableName("t_update_status_error")
@EqualsAndHashCode()
@Schema(description = "同步结算状态的错误表")
public class TUpdateStatusError {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
	private String id;
	/**
	 * 内容
	 */
	@Schema(description = "内容")
	private String title;
	/**
	 * 结算单号
	 */
	@Schema(description = "结算单号")
	private String settleNo;
	/**
	 * 结算单号类型 0 收入 1 支出
	 */
	@Schema(description = "结算单号类型 0 收入 1 支出")
	private String settleType;
	/**
	 * 结算单类型 0 社保  1公积金 2管理费 3风险金 4 商险 5 薪资
	 */
	@Schema(description = "结算单类型 0 社保  1公积金 2管理费 3风险金 4 商险 5 薪资")
	private String typeFlag;
	/**
	 * 创建人时间
	 */
	@Schema(description = "创建人时间")
	private Date createTime;
	/**
	 * 更新状态 0 未更新 1 已更新
	 */
	@Schema(description = "更新状态 0 未更新 1 已更新")
	private Integer status;

}
