package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author licancan
 * @description 商险已投保修改请求参数
 * @date 2022-12-08 20:16:34
 */
@Data
@Schema(description = "商险已投保修改请求参数")
public class InsuranceInsuredDetailParam implements Serializable {
	private static final long serialVersionUID = 1445608325251914773L;
	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;
	/**
	 * 变更后保单开始时间
	 */
	@Schema(description = "变更后保单开始时间")
	private String policyStart;

	/**
	 * 变更后保单结束时间
	 */
	@Schema(description = "变更后保单结束时间")
	private String policyEnd;

	/**
	 * 变更后投保类型
	 */
	@Schema(description = "变更后投保类型 1新增 3批增")
	private Integer buyType;

	/**
	 * 变更后的购买标准
	 */
	@Schema(description = "变更后的购买标准")
	private String buyStandard;

	/**
	 * 变更原因
	 */
	@Schema(description = "变更原因")
	private String reason;
}
