package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;

/**
 * @author zhaji
 * @description 减员办理返回类
 * @date 2022-07-21 12:30:37
 */
@Schema(name = "减员办理返回类")
@Data
public class InsuranceRefundResultVo implements Serializable {
	private static final long serialVersionUID = -2689686777914935788L;

	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 员工姓名
	 */
	@Schema(description = "员工姓名")
	private String empName;

	/**
	 * 员工身份证号
	 */
	@Schema(description = "员工身份证号")
	private String empIdcardNo;

	/**
	 * 项目名称
	 */
	@Schema(description = "项目名称")
	private String projectName;

	/**
	 * 项目编码
	 */
	@JsonIgnore
	private String deptNo;

	/**
	 * 投保岗位
	 */
	@Schema(description = "投保岗位")
	private String post;

	/**
	 * 保单开始时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单开始时间")
	private LocalDate policyStart;

	/**
	 * 保单结束时间
	 */
	@JsonFormat(shape = JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
	@Schema(description = "保单结束时间")
	private LocalDate policyEnd;

	/**
	 * 险种名称
	 */
	@Schema(description = "险种名称")
	private String insuranceTypeName;

	/**
	 * 保险公司名称
	 */
	@Schema(description = "保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 减员状态 1待减员 2减员中3减员退回
	 */
	@Schema(description = "减员状态 1待减员 2减员中3减员退回")
	private Integer reduceHandleStatus;

	/**
	 * 错误原因
	 */
	@Schema(description = "错误原因")
	private String errorMessage;
}
