package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.HeadFontStyle;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;

/**
 * @author huyc
 * @description 发票号更新VO
 * @date 2022-11-29 10:23:17
 */
@Data
@Schema(description = "发票号更新VO")
public class InsuranceUpdateVO implements Serializable {
	private static final long serialVersionUID = 628032758008497542L;
	/**
	 * 主键
	 */
	@Schema(description = "主键")
	private String id;

	/**
	 * 发票号
	 */
	@Schema(description = "发票号")
	private String invoiceNo;

	/**
	 * 保单号
	 */
	@Schema(description = "保单号")
	@HeadFontStyle(fontHeightInPoints = 11)
	@ExcelProperty(value = "保单号")
	private String policyNo;
}
