package com.yifu.cloud.plus.v1.yifu.insurances.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 商险待办任务表
 *
 * @author huych
 * @date 2025-03-31 12:25:13
 */
@Data
public class TEmployeeInsuranceExitCheckVo implements Serializable {

	/**
	 * 员工姓名
	 */
	@ExcelAttribute(name = "员工姓名")
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String employeeName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号")
	@Schema(description = "身份证号")
	@ExcelProperty("身份证号")
	private String empIdcard;

	/**
	 * 保险公司名称
	 */
	@ExcelAttribute(name = "保险公司名称")
	@Schema(description = "保险公司名称")
	@ExcelProperty("保险公司名称")
	private String insuranceCompanyName;

	/**
	 * 险种名称
	 */
	@ExcelAttribute(name = "险种名称")
	@Schema(description = "险种名称")
	@ExcelProperty("险种名称")
	private String insuranceTypeName;

	/**
	 * 购买标准
	 */
	@ExcelAttribute(name = "购买标准")
	@Schema(description = "购买标准")
	@ExcelProperty("购买标准")
	private String buyStandard;

	/**
	 * 购买类型， 1新增、3批增、4替换
	 */
	@ExcelAttribute(name = "购买类型， 1新增、3批增、4替换")
	@Schema(description = "购买类型， 1新增、3批增、4替换")
	@ExcelProperty("购买类型， 1新增、3批增、4替换")
	private Integer buyType;

	/**
	 * 保单开始时间
	 */
	@ExcelAttribute(name = "保单开始时间", isDate = true)
	@Schema(description = "保单开始时间")
	@ExcelProperty("保单开始时间")
	private Date policyStart;

	/**
	 * 保单结束时间
	 */
	@ExcelAttribute(name = "保单结束时间", isDate = true)
	@Schema(description = "保单结束时间")
	@ExcelProperty("保单结束时间")
	private Date policyEnd;
	/**
	 * 错误信息
	 */
	@ExcelAttribute(name = "错误信息")
	@Schema(description = "错误信息")
	@ExcelProperty("错误信息")
	private String errorMsg;

}
