package com.yifu.cloud.plus.v1.yifu.insurances.controller;

import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.insurances.service.insurance.TInsuranceEkpService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.HttpHeaders;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author zhaji
 * @description EKP重发类
 * @date 2022-08-23 17:35:47
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/insuranceEkp")
@Tag(name = "EKP重发类")
@SecurityRequirement(name = HttpHeaders.AUTHORIZATION)
public class TInsuranceEkpController {

	@Resource
	private TInsuranceEkpService tInsuranceEkpService;

	/**
	 * ekp重发
	 * @return
	 */
	@Operation(summary = "ekp重发", description = "ekp重发")
	@GetMapping("/resend" )
	public R resend() {
		return R.ok(tInsuranceEkpService.resend());
	}
}
