package com.yifu.cloud.plus.v1.yifu.insurances.mapper.insurances;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceType;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeRate;
import com.yifu.cloud.plus.v1.yifu.insurances.entity.TInsuranceTypeStandard;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceTypeExportVo;
import com.yifu.cloud.plus.v1.yifu.insurances.vo.InsuranceTypeVo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
* @author Administrator
* @description 针对表【t_insurance_type(险种表)】的数据库操作Mapper
* @createDate 2022-07-18 17:19:23
* @Entity generator.domain.TInsuranceType
*/
@Mapper
public interface TInsuranceTypeMapper extends BaseMapper<TInsuranceType> {

	/**
	 * 根据险种id查询费率
	 *
	 * @author zhaji
	 * @param id 险种id
	 * @return {@link List< TInsuranceTypeRate>}
	 */
    List<TInsuranceTypeRate> selectInsuranceTypeRateList(@Param("id") String id);
	/**
	 * 根据险种id查询购买标准
	 *
	 * @author zhaji
	 * @param id 险种id
	 * @return {@link List< TInsuranceTypeStandard>}
	 */
	List<TInsuranceTypeStandard> selectInsuranceTypeStandardList(String id);

	/**
	 * 险种分页查询
	 *
	 * @author zhaji
	 * @param page 分页参数
	 * @param insuranceType 查询参数
	 * @return {@link IPage<InsuranceTypeVo>}
	 */
    IPage<InsuranceTypeVo> selectInsuranceTypePage(Page page, @Param("insuranceType") InsuranceTypeVo insuranceType);

	List<InsuranceTypeExportVo> selectInsuranceType(@Param("insuranceType") InsuranceTypeVo insuranceType);

	InsuranceTypeVo getInsuranceTypeDetailById(String id);

}
