package com.yifu.cloud.plus.v1.job.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;


/**
 * @author wangan
 * @date 2019-08-12 10:19:42
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("sys_schedule_job_log")
@Schema(description = "定时任务执行记录表")
public class SysScheduleJobLog extends Model<SysScheduleJobLog> {
    private static final long serialVersionUID = 1L;
    /**
     *
     */
    @TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "主键")
    private String id;
    /**
     *
     */
    @Length(max = 100, message = "不能超过100个字符")
	@Schema(description = "任务ID")
    private String jobId;
    /**
     *
     */
    @Length(max = 20, message = "不能超过20个字符")
	@Schema(description = "执行类名称")
    private String beanName;
    /**
     *
     */
    @Length(max = 40, message = "不能超过40个字符")
	@Schema(description = "执行方法")
    private String methodName;
    /**
     *
     */
    @Length(max = 50, message = "不能超过50个字符")
	@Schema(description = "执行方法参数")
    private String params;
    /**
     *
     */
    @Length(max = 1, message = "不能超过1个字符")
	@Schema(description = "状态")
    private String status;
    /**
     *
     */
    @Length(max = 100, message = "不能超过100个字符")
	@Schema(description = "错误信息")
    private String error;
    /**
     *
     */
    @Length(max = 10, message = "不能超过10个字符")
	@Schema(description = "执行时长")
    private String times;
    /**
     *
     */
    @Length(max = 14, message = "不能超过14个字符")
	@Schema(description = "创建时间")
    private String createtime;
    /**
     *
     */
    @Length(max = 200, message = "不能超过200个字符")
	@Schema(description = "备注")
    private String remark;
}
