package com.yifu.cloud.plus.v1.yifu.order.util;

import com.yifu.cloud.plus.v1.yifu.order.service.TOrderService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.io.InputStream;

/**
 * @Author fxj
 * @Date 2023/6/25
 * @Description
 * @Version 1.0
 */
@Slf4j
@Component
public class EkpOrderFileTask {
	@Autowired
	TOrderService orderService;
	/**
	 * @Author fxj
	 * @Description 订单附件上传
	 * @Date 15:58 2023/6/25
	 * @Param
	 * @return
	**/
	@Async
	public void receiveOrderNew(InputStream inputStream, String file1, String orderNo, String fileName, String originalFileName,String fileIds){
		synchronized (this){
			try {
				orderService.receiveOrderNew(inputStream,file1,orderNo,fileName,originalFileName,fileIds);
			} catch (IOException e) {
				log.error("订单附件上传异常：",e);
			}
		}
	}

	@Async
	public void receiveOrderFileAsc(InputStream inputStream,String orderNo, String fileName, String originalFileName){
		orderService.receiveOrderFileAsc(inputStream,orderNo,fileName,originalFileName);
	}
}
