package com.yifu.cloud.plus.v1.yifu.permission.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 新权限-菜单表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
@Data
@TableName("sys_menu")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "新权限-菜单表")
public class SysMenu extends BaseEntity {

	/**
	 * ID
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@Schema(description = "ID")
	private String id;

	/**
	 * 菜单名称
	 */
	@Schema(description = "菜单名称")
	private String menuName;

	/**
	 * 上级菜单名称
	 */
	@Schema(description = "上级菜单名称")
	private String menuNameParent;

	/**
	 * 上级菜单id
	 */
	@Schema(description = "上级菜单id")
	private String menuParentId;

	/**
	 * 表单ID
	 */
	@Schema(description = "表单ID")
	private String modelId;

	/**
	 * 视图ID
	 */
	@Schema(description = "视图ID")
	private String viewId;

	/**
	 * 权限维度
	 */
	@Schema(description = "权限维度")
	private String permissionType;

	/**
	 * 授权状态（0启用、1禁用）
	 */
	@Schema(description = "授权状态（0启用、1禁用）")
	private String permissionStatus;

	/**
	 * 删除状态（0是、1否）
	 */
	@Schema(description = "删除状态（0是、1否）")
	private String deleteStatus;

	/**
	 * 收入权限id
	 */
	@Schema(description = "收入权限id")
	private String incomeId;

	/**
	 * 客户权限id
	 * 1客户权限；2商机；3报价单；4合同；5项目；6BU；7条线；8部门；9收入归属
	 */
	@Schema(description = "客户权限id")
	private String customerId;

	/**
	 * 合同权限id
	 */
	@Schema(description = "合同权限id")
	private String contractId;

	/**
	 * 商机权限id
	 */
	@Schema(description = "商机权限id")
	private String bussinessId;

	/**
	 * 报价单权限id
	 */
	@Schema(description = "报价单权限id")
	private String quotationId;

	/**
	 * 项目权限id
	 */
	@Schema(description = "项目权限id")
	private String domainId;

	/**
	 * BU归属权限id
	 */
	@Schema(description = "BU归属权限id")
	private String buId;

	/**
	 * 条线类型权限id
	 */
	@Schema(description = "条线类型权限id")
	private String lineId;

	/**
	 * 部门权限id
	 */
	@Schema(description = "部门权限id")
	private String deptId;

	/**
	 * 二级指标归属id
	 */
	@Schema(description = "二级指标归属id")
	private String twoLevelId;

	/**
	 * 权限idList
	 */
	@Schema(description = "权限idList")
	@TableField(exist = false)
	private List<String> columnIdList;

	/**
	 * 是否开关（0开、1关）
	 */
	@Schema(description = "是否开关（0开、1关）")
	private String isOpen;

	/**
	 * 表名，用来先查结果集
	 */
	@Schema(description = "表名，用来先查结果集")
	private String tableName;
	/**
	 * 查询字段维度，如果fdId超长，则使用本字段
	 */
	@Schema(description = "查询字段维度，如果fdId超长，则使用本字段")
	private String queryFields;

	/**
	 * 税务主体字段ID
	 */
	@Schema(description = "税务主体字段ID")
	private String taxId;

	/**
	 * 事业部权限id
	 */
	@Schema(description = "事业部权限id")
	private String divisionId;

	/**
	 * 事业部条线权限id
	 */
	@Schema(description = "事业部条线权限id")
	private String divisionLineId;


}
