package com.yifu.cloud.plus.v1.yifu.permission.vo;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.RowIndex;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 新权限-角色表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Data
public class SysRoleInfoVo extends RowIndex implements Serializable {

	/**
	 * 主键
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@NotBlank(message = "主键 不能为空")
	@Length(max = 36, message = "主键 不能超过36 个字符")
	@ExcelAttribute(name = "主键", isNotEmpty = true, errorInfo = "主键 不能为空", maxLength = 36)
	@Schema(description = "主键")
	@ExcelProperty("主键")
	private String fdId;
	/**
	 * 角色名称
	 */
	@NotBlank(message = "角色名称 不能为空")
	@Length(max = 20, message = "角色名称 不能超过20 个字符")
	@ExcelAttribute(name = "角色名称", isNotEmpty = true, errorInfo = "角色名称 不能为空", maxLength = 20)
	@Schema(description = "角色名称")
	@ExcelProperty("角色名称")
	private String roleName;
	/**
	 * 角色描述
	 */
	@Length(max = 200, message = "角色描述 不能超过200 个字符")
	@ExcelAttribute(name = "角色描述", maxLength = 200)
	@Schema(description = "角色描述")
	@ExcelProperty("角色描述")
	private String remark;
	/**
	 * 状态：0：正常；1：冻结/停用
	 */
	@NotBlank(message = "状态：0：正常；1：冻结/停用 不能为空")
	@ExcelAttribute(name = "状态：0：正常；1：冻结/停用", isNotEmpty = true, errorInfo = "状态：0：正常；1：冻结/停用 不能为空")
	@Schema(description = "状态：0：正常；1：冻结/停用")
	@ExcelProperty("状态：0：正常；1：冻结/停用")
	private Integer status;
	/**
	 * 删除状态图：0：正常；1：删除
	 */
	@NotBlank(message = "删除状态图：0：正常；1：删除 不能为空")
	@ExcelAttribute(name = "删除状态图：0：正常；1：删除", isNotEmpty = true, errorInfo = "删除状态图：0：正常；1：删除 不能为空")
	@Schema(description = "删除状态图：0：正常；1：删除")
	@ExcelProperty("删除状态图：0：正常；1：删除")
	private Integer deleteFlag;
	/**
	 * 数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；事业部i；事业部条线j；）
	 */
	@NotBlank(message = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；事业部i；事业部条线j；） 不能为空")
	@Length(max = 50, message = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；事业部i；事业部条线j；） 不能超过50 个字符")
	@ExcelAttribute(name = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；事业部i；事业部条线j；）", isNotEmpty = true, errorInfo = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；） 不能为空", maxLength = 50)
	@Schema(description = "数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；事业部i；事业部条线j；）")
	@ExcelProperty("数据权限（全量0；部分全量1；数据权限2；客户a；商机b；报价单c；合同d；项目e；BUf；条线g；收入归属h；事业部i；事业部条线j；）")
	private String dataAuth;
	/**
	 * 创建人id
	 */
	@Length(max = 36, message = "创建人id 不能超过36 个字符")
	@ExcelAttribute(name = "创建人id", maxLength = 36)
	@Schema(description = "创建人id")
	@ExcelProperty("创建人id")
	private String createBy;
	/**
	 * 创建人姓名
	 */
	@Length(max = 200, message = "创建人姓名 不能超过200 个字符")
	@ExcelAttribute(name = "创建人姓名", maxLength = 200)
	@Schema(description = "创建人姓名")
	@ExcelProperty("创建人姓名")
	private String createName;
	/**
	 * 创建时间
	 */
	@ExcelAttribute(name = "创建时间", isDate = true)
	@Schema(description = "创建时间")
	@ExcelProperty("创建时间")
	private LocalDateTime createTime;
	/**
	 * 更新人id
	 */
	@Length(max = 200, message = "更新人id 不能超过200 个字符")
	@ExcelAttribute(name = "更新人id", maxLength = 200)
	@Schema(description = "更新人id")
	@ExcelProperty("更新人id")
	private String updateBy;
	/**
	 * 更新时间
	 */
	@ExcelAttribute(name = "更新时间", isDate = true)
	@Schema(description = "更新时间")
	@ExcelProperty("更新时间")
	private LocalDateTime updateTime;

}
