package com.yifu.cloud.plus.v1.yifu.permission.vo;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.yifu.cloud.plus.v1.yifu.permission.entity.SysUserInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 新权限-账号管理表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
@Data
public class SysUserInfoSearchVo extends SysUserInfo {

	/**
	 * 多选导出或删除等操作
	 */
	@Schema(description = "选中ID,多个逗号分割")
	private String ids;

	/**
	 * 创建时间区间 [开始时间，结束时间]
	 */
	@Schema(description = "创建时间区间")
	private LocalDateTime[] createTimes;
	/**
	 * @Author fxj
	 * 查询数据起
	 **/
	@Schema(description = "查询limit  开始")
	private int limitStart;
	/**
	 * @Author fxj
	 * 查询数据止
	 **/
	@Schema(description = "查询limit  数据条数")
	private int limitEnd;

}
