package com.yifu.cloud.plus.v1.yifu.permission.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 新权限-用户权限表
 *
 * @author hyc
 * @date 2023-08-29 14:49:40
 */
@Data
public class SysUserPermissionExportVo implements Serializable {

	/**
	 * 员工姓名
	 */
	@Length(max = 20, message = "员工姓名 不能超过20 个字符")
	@ExcelAttribute(name = "员工姓名", maxLength = 20)
	@Schema(description = "员工姓名")
	@ExcelProperty("员工姓名")
	private String empName;
	/**
	 * 登录账号
	 */
	@NotBlank(message = "登录账号 不能为空")
	@Length(max = 10, message = "登录账号 不能超过10 个字符")
	@ExcelAttribute(name = "登录账号", isNotEmpty = true, errorInfo = "登录账号 不能为空", maxLength = 10)
	@Schema(description = "登录账号")
	@ExcelProperty("登录账号")
	private String empLoginName;
	/**
	 * 所属部门
	 */
	@Length(max = 20, message = "所属部门 不能超过20 个字符")
	@ExcelAttribute(name = "所属部门", maxLength = 20)
	@Schema(description = "所属部门")
	@ExcelProperty("所属部门")
	private String empDept;
	/**
	 * 权限类型
	 */
	@Length(max = 8, message = "权限类型 不能超过8 个字符")
	@ExcelAttribute(name = "权限类型", maxLength = 8)
	@Schema(description = "权限类型")
	@ExcelProperty("权限类型")
	private String permissionType;
	/**
	 * 名称
	 */
	@Length(max = 20, message = "名称 不能超过20 个字符")
	@ExcelAttribute(name = "名称", maxLength = 20)
	@Schema(description = "名称")
	@ExcelProperty("名称")
	private String name;
	/**
	 * 编码
	 */
	@Length(max = 30, message = "编码 不能超过30 个字符")
	@ExcelAttribute(name = "编码", maxLength = 30)
	@Schema(description = "编码")
	@ExcelProperty("编码")
	private String code;
	/**
	 * 是否包含(0 是 1否)
	 */
	@Length(max = 1, message = "是否含下级部门 不能超过1 个字符")
	@ExcelAttribute(name = "是否含下级部门", maxLength = 1)
	@Schema(description = "是否含下级部门")
	@ExcelProperty("是否含下级部门")
	private String isContains;
	/**
	 * 授权状态（0启用、1禁用）
	 */
	@Length(max = 1, message = "授权状态 不能超过1 个字符")
	@ExcelAttribute(name = "授权状态", maxLength = 1)
	@Schema(description = "授权状态")
	@ExcelProperty("授权状态")
	private String permissionStatus;

}
