package com.yifu.cloud.plus.v1.permission.controller;

import com.yifu.cloud.plus.v1.permission.service.QiWeiService;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.DateUtil;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiChuchai;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiWorkovertime;
import com.yifu.cloud.plus.v1.yifu.permission.entity.EkpQiwiZhaoPin;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 工资服务-获取微信
 *
 * @author hgw
 * @date 2024-4-10 11:26:50
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/qiWei")
@Tag(name = "工资服务-获取微信")
public class QiWeiController {

	private final QiWeiService wxSalaryService;

	/**
	 * @Description: 每日获取当日企业微信审批里的出差
	 * @Author: hgw
	 * @Date: 2024-4-11 11:03:34
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List < com.yifu.cloud.v1.hrms.api.entity.TEventFeeDetail>>
	 **/
	@PostMapping("/inner/everyDaySaveQiWeiChuChai")
	@Inner
	public R<List<EkpQiwiChuchai>> everyDaySaveQiWeiChuChai() {
		String startDay = DateUtil.addDay(-29);
		String endDay = DateUtil.addDay(0);
		return wxSalaryService.getQiWeiChuChaiAndSave(startDay, endDay, 1);
	}

	/**
	 * @param startTime
	 * @param endTime
	 * @Description: 获取企业微信审批里的出差
	 * @Author: hgw
	 * @Date: 2024-4-11 11:03:30
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List < com.yifu.cloud.v1.hrms.api.entity.TStatisticsProjectReimburse>>
	 **/
	@Operation(description = "获取企业微信审批里的出差数据：startTime格式：2024-04-10")
	@PostMapping("/getQiWeiChuCHaiInfoAndSave")
	//@PreAuthorize("@pms.hasPermission('wxhr:wxsalaryauth')")
	public R<List<EkpQiwiChuchai>> getQiWeiChuCHaiInfoAndSave(@RequestParam String startTime, @RequestParam String endTime) {
		return wxSalaryService.getQiWeiChuChaiAndSave(startTime, endTime, 1);
	}

	/**
	 * @Description: 每日获取当日HCM的E人事审批里的出差
	 * @Author: hgw
	 * @Date: 2024-4-28 16:51:16
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List < com.yifu.cloud.v1.hrms.api.entity.TEventFeeDetail>>
	 **/
	@PostMapping("/inner/everyDaySaveHcmChuChai")
	@Inner
	public R<List<EkpQiwiChuchai>> everyDaySaveHcmChuChai() {
		String startDay = DateUtil.addDay(-1);
		String endDay = DateUtil.addDay(0);
		return wxSalaryService.getQiWeiChuChaiAndSave(startDay, endDay, 2);
	}

	/**
	 * @param startTime
	 * @param endTime
	 * @Description: 获取HCM的E人事审批里的出差
	 * @Author: hgw
	 * @Date: 2024-4-28 16:51:39
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List < com.yifu.cloud.v1.hrms.api.entity.TStatisticsProjectReimburse>>
	 **/
	@Operation(description = "获取HCM的E人事审批里的出差：startTime格式：2024-04-10")
	@PostMapping("/getHcmChuChaiInfoAndSave")
	//@PreAuthorize("@pms.hasPermission('wxhr:wxsalaryauth')")
	public R<List<EkpQiwiChuchai>> getHcmChuChaiInfoAndSave(@RequestParam String startTime, @RequestParam String endTime) {
		return wxSalaryService.getQiWeiChuChaiAndSave(startTime, endTime, 2);
	}

	/**
	 * @Description: 每日获取当日企业微信审批里的【招聘平台采购/调配】
	 * @Author: hgw
	 * @Date: 2024-8-22 11:16:58
	 * @return: com.yifu.cloud.v1.common.core.util.R<java.util.List < com.yifu.cloud.v1.hrms.api.entity.TEventFeeDetail>>
	 **/
	@PostMapping("/inner/everyDaySaveQiWeiZhaoPin")
	@Inner
	public R<List<EkpQiwiZhaoPin>> everyDaySaveQiWeiZhaoPin() {
		String startDay = DateUtil.addDay(-29);
		String endDay = DateUtil.addDay(0);
		return wxSalaryService.getQiWeiZhaoPinAndSave(startDay, endDay);
	}

	/**
	 * @Description: 手动同步企微信息--EKP调用接口
	 * @Author: hgw
	 * @Date: 2024-8-28 11:23:18
	 **/
	@Operation(summary = "手动同步企微信息--EKP调用接口", description = "手动同步企微信息--EKP调用接口")
	@SysLog("手动同步企微信息--EKP调用接口")
	@GetMapping("/getQiWeiZhaoPinInfo")
	public R<String> getQiWeiZhaoPinInfo() {
		String startDay = DateUtil.addDay(-29);
		String endDay = DateUtil.addDay(0);
		R<List<EkpQiwiZhaoPin>> returnR = wxSalaryService.getQiWeiZhaoPinAndSave(startDay, endDay);
		if (returnR != null && returnR.getCode() == CommonConstants.SUCCESS) {
			return R.ok();
		}
		return R.failed();
	}

	/**
	 * @param startTime
	 * @param endTime
	 * @Description: 获取企业微信审批里的【招聘平台采购/调配】
	 * @Author: hgw
	 * @Date: 2024-8-22 11:16:58
	 **/
	@Operation(description = "获取企业微信审批里的招聘平台采购数据：startTime格式：2024-04-10")
	@PostMapping("/getQiWeiZhaoPinInfoAndSave")
	public R<List<EkpQiwiZhaoPin>> getQiWeiZhaoPinInfoAndSave(@RequestParam String startTime, @RequestParam String endTime) {
		return wxSalaryService.getQiWeiZhaoPinAndSave(startTime, endTime);
	}

	/**
	 * 手动同步当日HCM的E人事审批里的出差
	 * @author chenyuxi
	 * @date 2024-10-17
	 * @since 1.9.0
	 **/
	@Operation(summary = "手动同步当日HCM的E人事审批里的出差--EKP调用接口")
	@SysLog("手动同步当日HCM的E人事审批里的出差--EKP调用接口")
	@GetMapping("/getEChuchaiInfo")
	public R<String> getEChuchaiInfo() {
		String startDay = DateUtil.addDay(0);
		String endDay = DateUtil.addDay(0);
		R<List<EkpQiwiChuchai>> returnR = wxSalaryService.getQiWeiChuChaiAndSave(startDay, endDay, 2);
		if (returnR != null && returnR.getCode() == CommonConstants.SUCCESS) {
			return R.ok();
		}
		return R.failed();
	}

	/**
	 * 获取HCM审批通过的加班数据并存储到EKP
	 * @author chenyuxi
	 * @since  1.9.6
	 * @date   2025-02-06
	 * @return R<List<EkpQiwiChuchai>>
	 **/
	@PostMapping("/inner/everyDaySaveHcmWorkOvertime")
	@Inner
	public R<List<EkpQiwiWorkovertime>> everyDaySaveHcmWorkOvertime() {
		String startDay = DateUtil.addDay(-1);
		String endDay = DateUtil.addDay(0);
		return wxSalaryService.getHcmWorkOvertimeAndSave(startDay, endDay);
	}

	/**
	 * 初次获取HCM审批通过的加班数据并存储到EKP
	 * @author chenyuxi
	 * @since  1.9.6
	 * @date   2025-02-06
	 * @return R<List<EkpQiwiChuchai>>
	 **/
	@Operation(summary = "初次获取HCM审批通过的加班数据并存储到EKP")
	@SysLog("初次获取HCM审批通过的加班数据并存储到EKP")
	@GetMapping("/initialSaveHcmWorkOvertime")
	public R<List<EkpQiwiWorkovertime>> initialSaveHcmWorkOvertime() {
		String startDay = DateUtil.addDay(-29);
		String endDay = DateUtil.addDay(0);
		return wxSalaryService.getHcmWorkOvertimeAndSave(startDay, endDay);
	}

	/**
	 * 手动同步当日HCM的加班数据并存储到EKP
	 * @author chenyuxi
	 * @date 2024-10-17
	 * @since 1.9.6
	 **/
	@Operation(summary = "手动同步当日HCM的E人事审批里的加班数据--EKP调用接口")
	@SysLog("手动同步当日HCM的E人事审批里的加班数据--EKP调用接口")
	@GetMapping("/getEWorkOvertimeInfo")
	public R<String> getEWorkOvertimeInfo() {
		String startDay = DateUtil.addDay(0);
		String endDay = DateUtil.addDay(0);
		R<List<EkpQiwiWorkovertime>> returnR = wxSalaryService.getHcmWorkOvertimeAndSave(startDay, endDay);
		if (returnR != null && returnR.getCode() == CommonConstants.SUCCESS) {
			return R.ok();
		}
		return R.failed();
	}

}
