package com.yifu.cloud.plus.v1.permission.service;/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.yifu.cloud.plus.v1.yifu.permission.entity.SysRoleMenuRes;
import com.yifu.cloud.plus.v1.yifu.permission.vo.SysRoleMenuResSearchVo;

import java.util.List;

/**
 * 新权限-角色-菜单-关联表
 *
 * @author hgw
 * @date 2023-08-29 14:49:40
 */
public interface SysRoleMenuResService extends IService<SysRoleMenuRes> {
	/**
	 * 新权限-角色-菜单-关联表简单分页查询
	 *
	 * @param sysRoleMenuRes 新权限-角色-菜单-关联表
	 * @return
	 */
	IPage<SysRoleMenuRes> getSysRoleMenuResPage(Page<SysRoleMenuRes> page, SysRoleMenuResSearchVo sysRoleMenuRes);

	List<SysRoleMenuRes> noPageDiy(SysRoleMenuResSearchVo searchVo);

	/**
	 * @param roleId
	 * @Description: 根据角色删除关联表
	 * @Author: hgw
	 * @Date: 2023/8/30 15:19
	 * @return: boolean
	 **/
	boolean deleteByRoleId(String roleId);

}
