package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodePrimission;
import com.yifu.cloud.plus.v1.yifu.process.service.TNodePrimissionService;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.validation.Valid;
import java.util.List;
import java.util.Set;


/**
 * 流程处理权限表（允许多个，多个代表有主办和经办）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tnodeprimission")
@Tag(name = "流程处理权限表（允许多个，多个代表有主办和经办）")
public class TNodePrimissionController {

	@Resource
     private TNodePrimissionService tNodePrimissionService;

     /**
      * 简单分页查询
      *
      * @param page            分页对象
      * @param tNodePrimission 流程处理权限表（允许多个，多个代表有主办和经办）
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TNodePrimission>> getTNodePrimissionPage(Page<TNodePrimission> page, TNodePrimission tNodePrimission) {
          return new R<>(tNodePrimissionService.getTNodePrimissionPage(page, tNodePrimission));
     }


     /**
      * 通过id查询单条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TNodePrimission> getById(@PathVariable("id") String id) {
          return new R<>(tNodePrimissionService.getById(id));
     }

     /**
      * 新增记录
      *
      * @param tNodePrimission
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<Boolean> save(@Valid @RequestBody TNodePrimission tNodePrimission) {
          return new R<>(tNodePrimissionService.save(tNodePrimission));
     }

     /**
      * 修改记录
      *
      * @param tNodePrimission
      * @return R
      */
	 @Operation(summary = "修改")
     @SysLog("修改流程处理权限表（允许多个，多个代表有主办和经办）")
     @PutMapping
     public R<Boolean> update(@RequestBody TNodePrimission tNodePrimission) {
          return new R<>(tNodePrimissionService.updateById(tNodePrimission));
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除流程处理权限表（允许多个，多个代表有主办和经办）")
     @DeleteMapping("/{id}")
     public R<Boolean> removeById(@PathVariable String id) {
          return new R<>(tNodePrimissionService.removeById(id));
     }

     /**
      * todo 功能描述: 通过流程ID查询对应的办理人和归档人
      * @Param: [processId]
      * @Return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<java.util.List<TNodePrimission>>
      * @Author: zhouyang
      * @Date: 2021/12/2 16:23
      */
     @Inner
     @GetMapping("/inner/getTNodePrimission/byProcessId")
     public R<List<TNodePrimission>> getTNodePrimissionByProcessId(@RequestParam("processId") Set<String> processId){
          List<TNodePrimission> list = tNodePrimissionService.list(Wrappers.<TNodePrimission>query().lambda().in(TNodePrimission::getProcessId, processId));
          return new R<>(list);
     }

}
