package com.yifu.cloud.plus.v1.yifu.process.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.common.core.vo.YifuUser;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.CommonConstants;
import com.yifu.cloud.plus.v1.yifu.common.core.util.Common;
import com.yifu.cloud.plus.v1.yifu.common.core.util.R;
import com.yifu.cloud.plus.v1.yifu.common.log.annotation.SysLog;
import com.yifu.cloud.plus.v1.yifu.process.entity.TProcess;
import com.yifu.cloud.plus.v1.yifu.process.vo.ProcessVo;
import com.yifu.cloud.plus.v1.yifu.process.vo.TProcessViewVo;
import com.yifu.cloud.plus.v1.yifu.process.service.TProcessService;
import com.yifu.cloud.plus.v1.yifu.common.security.annotation.Inner;
import com.yifu.cloud.plus.v1.yifu.common.security.util.SecurityUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import lombok.extern.log4j.Log4j2;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.time.LocalDateTime;


/**
 * 主流程表
 *
 * @author chenyuxi
 * @date 2020-07-16 15:44:02
 */
@RestController
@RequiredArgsConstructor
@RequestMapping("/tprocess")
@Tag(name = "主流程表")
@Log4j2
public class TProcessController {

	@Resource
     private TProcessService tProcessService;

     /**
      * 简单分页查询
      *
      * @param page     分页对象
      * @param tProcess 主流程表
	  * @param type     0:在用流程 1非在用
      * @return
      */
	 @Operation(summary = "简单分页查询")
     @GetMapping("/page")
     public R<IPage<TProcessViewVo>> getTProcessPage(Page<TProcessViewVo> page, TProcessViewVo tProcess,String type) {
          return new R<>(tProcessService.getTProcessPage(page, tProcess,type));
     }

     /**
      * 通过id查询单条记录
      * @param id
      * @return R
      */
	 @Operation(summary = "id查询")
     @GetMapping("/{id}")
     public R<TProcess> getById(@PathVariable("id") String id) {
          return new R<>(tProcessService.getById(id));
     }


    /**
     * 通过ids查询多条记录
     * @param ids
     * @return R
     */
	@Operation(summary = "ids查询")
    @GetMapping("/get/byIds")
    public R<TProcess> getByIds(@RequestParam("ids") String[] ids) {
        return new R(tProcessService.list(Wrappers.<TProcess>query().lambda().in(TProcess::getId,ids)));
    }

     /**
      * @param id
      * @Description: 根据id查询ProcessVo
      * @Author: hgw
      * @Date: 2020/7/17 11:05
      * @return: com.yifu.cloud.plus.v1.yifu.common.core.util.R<ProcessVo>
      **/
	 @Operation(summary = "根据id查询ProcessVo")
     @GetMapping("/getProcessVoById")
     public R<ProcessVo> getProcessVoById(String id) {
          return new R<>(tProcessService.getProcessVoById(id));
     }

     /**
      * 根据流程类型查询ProcessVo
	  * @param processType 流程类型
      * @return R<ProcessVo>
	  * @since mvp1.7.5
      **/
     @PostMapping("/inner/getProcessVoByType")
     @Inner
     public ProcessVo getProcessVoByType(@RequestBody String processType) {
          return tProcessService.getProcessVoByType(processType);
     }

	/**
	 * 根据流程Id查询ProcessVo
	 * @param processId 流程类型
	 * @return R<ProcessVo>
	 * @since mvp1.7.5
	 **/
	@PostMapping("/inner/getProcessVoByProcessId")
	@Inner
	public ProcessVo getProcessVoByProcessId(@RequestBody String processId) {
		return tProcessService.getProcessVoById(processId);
	}

     /**
      * 新增记录
      * @param processVo
      * @return R
      */
	 @Operation(summary = "新增流程")
     @PostMapping("/saveProcessVo")
     public R saveProcessVo(@RequestBody ProcessVo processVo) {return tProcessService.saveProcessVo(processVo);}

     /**
      * 新增记录
      *
      * @param tProcess
      * @return R
      */
	 @Operation(summary = "新增")
     @PostMapping
     public R<String> save(@RequestBody TProcessViewVo tProcess) {
		  YifuUser user = SecurityUtils.getUser();
          tProcess.setCreateDate(LocalDateTime.now());
          tProcess.setCreateUser(String.valueOf(user.getId()));
          return tProcessService.add(tProcess);
     }


    /**
      * 修改记录
      *
      * @param vo
      * @return R
      */
	 @Operation(summary = "修改")
     @SysLog("修改主流程表")
     @PutMapping
     public R<String> update(@RequestBody TProcessViewVo vo) {
	 	  YifuUser user = SecurityUtils.getUser();
          vo.setUpdateDate(LocalDateTime.now());
          vo.setUpdateUser(String.valueOf(user.getId()));
          return tProcessService.modify(vo);
     }

     /**
      * 通过id删除一条记录
      *
      * @param id
      * @return R
      */
	 @Operation(summary = "删除")
     @SysLog("删除主流程表")
     @DeleteMapping("/{id}")
     public R removeById(@PathVariable String id) {
         return tProcessService.delete(id);
     }

    /**
     * 审批角色流程检测
     *
     * @param tProcess 审批角色
     * @return R<List<ProcessVo>>
     * @author chenyuxi
     * @date 2023-10-23 09:48:57
     * @since crm2.12.0
     */
	@Operation(summary = "审批角色流程检测列表")
    @GetMapping("/getProcessPageByRoleId")
    public R<IPage<TProcessViewVo>> getProcessPageByRoleId(Page<TProcessViewVo> page, TProcessViewVo tProcess) {
        if(Common.isEmpty(tProcess.getRole())) {
            return R.failed("审批角色Id不能为空");
        }
        // 设置角色类型:5指定角色(crm)
        tProcess.setNodePermissionType(CommonConstants.FIVE_INT);
        return new R<>(tProcessService.getProcessPageByRoleId(page, tProcess));
    }

    /**
     * 审批角色流程检测
     *
     * @param tProcess 审批角色
     * @return R<List<ProcessVo>>
     * @author chenyuxi
     * @date 2023-10-23 09:48:57
     * @since crm2.12.0
     */
	@Operation(summary = "审批角色流程检测")
    @GetMapping("/checkProcessByRoleId")
    public R<String> checkProcessByRoleId(TProcessViewVo tProcess) {
        if(Common.isEmpty(tProcess.getRole())) {
            return R.failed("审批角色Id不能为空");
        }
        // 设置角色类型:5指定角色(crm)
        tProcess.setNodePermissionType(CommonConstants.FIVE_INT);
        return new R<>(tProcessService.checkProcessByRoleId(tProcess));
    }


    /**
     * 流程弃用（弃用的流程会在历史流程列表里）
     * @Author: wangdayu
     * @Date: 2023年10月24日14:46
     * @param id:流程id
     * @return R
     */
	@Operation(summary = "流程弃用（弃用的流程会在历史流程列表里")
    @GetMapping("/noUse")
    public R<String> noUse(@RequestParam(value = "id") String id) {
        TProcess tProcess = new TProcess();
        tProcess.setId(id);
        return tProcessService.noUse(tProcess);
    }
}
