package com.yifu.cloud.plus.v1.yifu.process.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yifu.cloud.plus.v1.yifu.process.entity.TNodeRoute;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

/**
 * 流程路由表（节点与节点之间的路由关系）
 *
 * @author hgw
 * @date 2020-07-16 15:44:02
 */
@Mapper
public interface TNodeRouteMapper extends BaseMapper<TNodeRoute> {
     /**
      * 流程路由表（节点与节点之间的路由关系）简单分页查询
      *
      * @param tNodeRoute 流程路由表（节点与节点之间的路由关系）
      * @return
      */
     IPage<TNodeRoute> getTNodeRoutePage(Page<TNodeRoute> page, @Param("tNodeRoute") TNodeRoute tNodeRoute);

     /**
      * @param processId 流程id
      * @Description: 删除
      * @Author: hgw
      * @Date: 2020/7/17 11:32
      * @return: int
      **/
     int deleteByProcessId(@Param("processId") String processId);

}
