/*
 *    Copyright (c) 2018-2025, lengleng All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * Neither the name of the yifu4cloud.com developer nor the names of its
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 * Author: lengleng (wangiegie@gmail.com)
 */

package com.yifu.cloud.plus.v1.yifu.salary.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yifu.cloud.plus.v1.yifu.common.core.constant.ExcelAttribute;
import com.yifu.cloud.plus.v1.yifu.common.mybatis.base.BaseEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import java.util.Date;

/**
 * @author fxj
 * @date 2024-12-18 15:39:56
 */
@Data
@TableName("t_mobile_change_info")
@EqualsAndHashCode(callSuper = true)
@Schema(description = "")
public class TMobileChangeInfo extends BaseEntity {

	/**
	 * id
	 */
	@TableId(type = IdType.ASSIGN_ID)
	@ExcelProperty("id")
	@Schema(description = "id")
	private String id;
	/**
	 * 申请人姓名
	 */
	@ExcelAttribute(name = "申请人姓名", isNotEmpty = true, errorInfo = "申请人姓名不能为空", maxLength = 59)
	@NotBlank(message = "申请人姓名不能为空")
	@Length(max = 59, message = "申请人姓名不能超过59个字符")
	@ExcelProperty("申请人姓名")
	@Schema(description = "申请人姓名")
	private String applyName;
	/**
	 * 身份证号
	 */
	@ExcelAttribute(name = "身份证号", isNotEmpty = true, errorInfo = "身份证号不能为空", maxLength = 20)
	@NotBlank(message = "身份证号不能为空")
	@Length(max = 20, message = "身份证号不能超过20个字符")
	@ExcelProperty("身份证号")
	@Schema(description = "身份证号")
	private String empIdcard;
	/**
	 * 原号码
	 */
	@ExcelAttribute(name = "原号码", maxLength = 15)
	@Length(max = 15, message = "原号码不能超过15个字符")
	@ExcelProperty("原号码")
	@Schema(description = "原号码")
	private String mobileOld;
	/**
	 * 新号码
	 */
	@ExcelAttribute(name = "新号码", maxLength = 15)
	@Length(max = 15, message = "新号码不能超过15个字符")
	@ExcelProperty("新号码")
	@Schema(description = "新号码")
	private String mobileNew;
	/**
	 * 处理状态：待处理、处理中、已处理、手动更新
	 */
	@ExcelAttribute(name = "处理状态：待处理、处理中、已处理、手动更新", maxLength = 10)
	@Length(max = 10, message = "处理状态：待处理、处理中、已处理、手动更新不能超过10个字符")
	@ExcelProperty("处理状态：待处理、处理中、已处理、手动更新")
	@Schema(description = "处理状态：待处理、处理中、已处理、手动更新")
	private String handleStatus;
	/**
	 * 处理人
	 */
	@ExcelAttribute(name = "处理人", maxLength = 20)
	@Length(max = 20, message = "处理人不能超过20个字符")
	@ExcelProperty("处理人")
	@Schema(description = "处理人")
	private String handleOperator;
	/**
	 * 处理完成时间
	 */
	@ExcelAttribute(name = "处理完成时间", isDate = true)
	@ExcelProperty("处理完成时间")
	@Schema(description = "处理完成时间")
	private Date handleFinishTime;
	/**
	 * 处理说明
	 */
	@ExcelAttribute(name = "处理说明", maxLength = 200)
	@Length(max = 200, message = "处理说明不能超过200个字符")
	@ExcelProperty("处理说明")
	@Schema(description = "处理说明")
	private String handleRemark;

	/**
	 * 验证码
	 */
	@TableField(exist = false)
	private String sendCode;

}
